/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mesutils;

import com.modelengineers.MoRe_elk.alg.layered.options.CrossingMinimizationStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.CycleBreakingStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeringStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.NodePlacementStrategy;
import com.modelengineers.MoRe_elk.graph.properties.IPropertyHolder;

public final class MesGraphPropertiesConfigurator {
    public static final double SPACING_NODE_NODE = 6.0;
    public static final double SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND = 15.0;
    public static final double SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_UPPER_BOUND = 40.0;
    public static final int THOROUGHNESS = 300;
    public static final double CROSSING_MINIMIZATION_HIERARCHICAL_SWEEPINESS = -2.0;
    public static final int CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD = 0;
    public static final int MINIMUM_HYPEREDGE_DUMMY_MERGE_LENGTH_INTERACTIVE = 1;

    private MesGraphPropertiesConfigurator() {
    }

    public static void setGraphProperties(IPropertyHolder graph, boolean isInteractiveMode, boolean adjustNodeHeights, boolean loggingEnabled) {
        MesGraphPropertiesConfigurator.setModeDependentGraphProperties(graph, isInteractiveMode);
        MesGraphPropertiesConfigurator.setModeIndependentGraphProperties(graph, adjustNodeHeights, loggingEnabled);
    }

    private static void setModeDependentGraphProperties(IPropertyHolder graph, boolean isInteractiveMode) {
        if (isInteractiveMode) {
            graph.setProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY, CycleBreakingStrategy.INTERACTIVE);
            graph.setProperty(LayeredOptions.LAYERING_STRATEGY, LayeringStrategy.INTERACTIVE);
            graph.setProperty(LayeredOptions.CROSSING_MINIMIZATION_STRATEGY, CrossingMinimizationStrategy.INTERACTIVE);
            graph.setProperty(LayeredOptions.MINIMUM_HYPEREDGE_MERGE_LENGTH, 1);
        } else {
            graph.setProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY, CycleBreakingStrategy.NONE);
            graph.setProperty(LayeredOptions.LAYERING_STRATEGY, LayeringStrategy.MES_MORE);
        }
    }

    private static void setModeIndependentGraphProperties(IPropertyHolder graph, boolean adjustNodeHeights, boolean loggingEnabled) {
        graph.setProperty(LayeredOptions.ADJUST_NODE_HEIGHTS, adjustNodeHeights);
        graph.setProperty(LayeredOptions.NODE_PLACEMENT_STRATEGY, NodePlacementStrategy.MES_MORE);
        graph.setProperty(LayeredOptions.SPACING_NODE_NODE, 6.0);
        graph.setProperty(LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND, 15.0);
        graph.setProperty(LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_UPPER_BOUND, 40.0);
        graph.setProperty(LayeredOptions.THOROUGHNESS, 300);
        graph.setProperty(LayeredOptions.CROSSING_MINIMIZATION_GREEDY_SWITCH_ACTIVATION_THRESHOLD, 0);
        graph.setProperty(LayeredOptions.ENABLE_LOGGING_MES_MORE, loggingEnabled);
    }
}

