/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VerticalSegmentsOfEdgesFromSameSourceShouldBeMerged {
    private static final int MAX_ALLOWED_X_DISTANCE_OF_VERTICAL_EDGE_SEGMENTS = 200;
    private static final int MAX_LENGTH_OF_TOP_OR_BOTTOM_SEGMENT = 50;
    private static final int MARGIN = 5;
    private ElkNode graph;
    private List<ElkRectangle> nodeWithLabelRectangles = new ArrayList<ElkRectangle>();

    public VerticalSegmentsOfEdgesFromSameSourceShouldBeMerged(ElkNode graph) {
        this.graph = graph;
        graph.getChildren().forEach(n -> {
            boolean bl = this.nodeWithLabelRectangles.add(NodeLabelEdgeIntersection.getNodeRectangle(n));
        });
    }

    public List<String> getSrcNodesOfViolations() {
        Stream<ElkPort> srcPorts = this.graph.getContainedEdges().stream().map(e -> (ElkPort)e.getSources().get(0)).distinct();
        List<String> srcNodesOfViolations = srcPorts.filter(srcPort -> this.hasVerticalSegmentsThatShouldBeMerged((ElkPort)srcPort)).map(p -> p.getParent().toString()).collect(Collectors.toList());
        return srcNodesOfViolations.isEmpty() ? null : srcNodesOfViolations;
    }

    private boolean hasVerticalSegmentsThatShouldBeMerged(ElkPort port) {
        List<ElkUtil.Segment> verticalSegments = this.getVerticalSegmentsWithoutShortTopAndBottomPortSegmentsOfOutgoingEdges(port);
        return MesUtilMethods.getUniquePairsAsStream(verticalSegments).anyMatch(pair -> this.segmentsShouldBeMerged((ElkUtil.Segment)pair.getFirst(), (ElkUtil.Segment)pair.getSecond()));
    }

    private List<ElkUtil.Segment> getVerticalSegmentsWithoutShortTopAndBottomPortSegmentsOfOutgoingEdges(ElkPort port) {
        return port.getOutgoingEdges().stream().flatMap(e -> this.getVerticalSegmentsWithoutShortTopAndBottomPortSegments((ElkEdge)e)).collect(Collectors.toList());
    }

    private Stream<ElkUtil.Segment> getVerticalSegmentsWithoutShortTopAndBottomPortSegments(ElkEdge edge) {
        List<ElkUtil.Segment> segments = ElkUtil.getSegments(edge);
        return segments.stream().filter(s -> s.isVertical() && !VerticalSegmentsOfEdgesFromSameSourceShouldBeMerged.isShortTopOrBottomPortSegment(s, segments));
    }

    private static boolean isShortTopOrBottomPortSegment(ElkUtil.Segment segment, List<ElkUtil.Segment> segments) {
        return (segments.get(0).equals(segment) || segments.get(segments.size() - 1).equals(segment)) && segment.getLength() <= 50.0;
    }

    private boolean segmentsShouldBeMerged(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        return s1.overlapsVertically(s2) && VerticalSegmentsOfEdgesFromSameSourceShouldBeMerged.segmentsAreTooClose(s1, s2) && this.noNodeBetweenSegments(s1, s2);
    }

    private static boolean segmentsAreTooClose(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        double distance = Math.abs(s2.getHigherPoint().x - s1.getHigherPoint().x);
        return distance >= 1.0 && distance < 200.0;
    }

    private boolean noNodeBetweenSegments(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        ElkRectangle segmentsRectangle = this.getSegmentsOverlapRectangle(s1, s2);
        return this.nodeWithLabelRectangles.stream().noneMatch(nr -> nr.intersects(segmentsRectangle));
    }

    private ElkRectangle getSegmentsOverlapRectangle(ElkUtil.Segment s1, ElkUtil.Segment s2) {
        double width = Math.abs(s1.getHigherPoint().x - s2.getHigherPoint().x);
        double height = s1.getVerticalOverlapLength(s2) + 10.0;
        double left = Math.min(s1.getHigherPoint().x, s2.getHigherPoint().x);
        double top = Math.max(s1.getHigherPoint().y, s2.getHigherPoint().y) - 5.0;
        return new ElkRectangle(left, top, width, height);
    }
}

