/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.stream.Stream;

public class TwigNotBelowSplitEdge {
    private ElkNode graph;

    public TwigNotBelowSplitEdge(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        ElkNode foundTwigNode = this.getTwigNodes().filter(this::isNotBelowSplitEdge).findFirst().orElse(null);
        return foundTwigNode == null ? "" : TwigNotBelowSplitEdge.getErrorMsg(foundTwigNode);
    }

    private Stream<ElkNode> getTwigNodes() {
        return this.graph.getChildren().stream().filter(n -> TwigNotBelowSplitEdge.isTwigNode(n));
    }

    private static boolean isTwigNode(ElkNode node) {
        if (node.getPorts().size() == 1) {
            ElkPort port = (ElkPort)node.getPorts().get(0);
            return port.getOutgoingEdges().size() == 0 && port.getIncomingEdges().size() == 1;
        }
        return false;
    }

    private boolean isNotBelowSplitEdge(ElkNode node) {
        ElkEdge inEdge = (ElkEdge)((ElkPort)node.getPorts().get(0)).getIncomingEdges().get(0);
        ElkPort srcPort = (ElkPort)inEdge.getSources().get(0);
        if (srcPort.getOutgoingEdges().size() == 2) {
            ElkEdge splitEdge = srcPort.getOutgoingEdges().stream().filter(e -> e != inEdge).findFirst().get();
            return this.isNotBelowSplitEdge(node, splitEdge);
        }
        return false;
    }

    private boolean isNotBelowSplitEdge(ElkNode node, ElkEdge splitEdge) {
        return ElkUtil.getSegments(splitEdge).stream().anyMatch(s -> s.isHorizontal() && this.xOverlap(node, (ElkUtil.Segment)s) && s.getStartPoint().y >= node.getY());
    }

    private boolean xOverlap(ElkNode node, ElkUtil.Segment segment) {
        double startX = segment.getStartPoint().x;
        double endX = segment.getEndPoint().x;
        return this.inInterval(node.getX(), startX, endX) || this.inInterval(node.getX() + node.getWidth(), startX, endX);
    }

    private boolean inInterval(double x, double startX, double endX) {
        return x >= startX && x <= endX;
    }

    private static String getErrorMsg(ElkNode foundTwigNode) {
        return "Twig node " + MesUtilMethods.getNameOfNode(foundTwigNode) + " not below split edge";
    }
}

