/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.util.Pair;
import com.modelengineers.MoRe_elk.core.util.feedbackloop.Finder;
import com.modelengineers.MoRe_elk.core.util.feedbackloop.IGraphAdapter;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public final class SelfCrossingFeedbackLoop {
    private ElkNode graph;
    private NodeLabelEdgeIntersection nodeLabelEdgeIntersection;
    private Pair<ElkEdge, ElkEdge> crossingPairOfEdges;

    public SelfCrossingFeedbackLoop(ElkNode graph) {
        this.graph = graph;
        this.nodeLabelEdgeIntersection = new NodeLabelEdgeIntersection(graph);
    }

    public String getErrorMsg() {
        return this.foundCrossingEdgesOfFeedbackLoop() ? this.getErrorMsgFromFoundCrossingEdges() : "";
    }

    private boolean foundCrossingEdgesOfFeedbackLoop() {
        return this.getEdgesOfFeedbackLoops().anyMatch(e -> this.containsCrossingEdges((List<ElkEdge>)e));
    }

    private Stream<List<ElkEdge>> getEdgesOfFeedbackLoops() {
        return this.getFeedbackLoops().stream().map(l -> this.getEdgesOfFeedbackLoop((List<ElkNode>)l));
    }

    private List<List<ElkNode>> getFeedbackLoops() {
        Finder<ElkNode> feedbackLoopFinder = new Finder<ElkNode>(new ElkGraphAdapter(this.graph));
        return feedbackLoopFinder.findAll();
    }

    private List<ElkEdge> getEdgesOfFeedbackLoop(List<ElkNode> feedbackLoop) {
        ArrayList edgesOfFeedbackLoop = Lists.newArrayList();
        int i = 0;
        while (i < feedbackLoop.size()) {
            ElkNode source = feedbackLoop.get(i);
            ElkNode target = feedbackLoop.get((i + 1) % feedbackLoop.size());
            edgesOfFeedbackLoop.addAll(source.getOutgoingEdgesTo(target));
            ++i;
        }
        return edgesOfFeedbackLoop;
    }

    private boolean containsCrossingEdges(List<ElkEdge> edgesOfFeedbackLoop) {
        return MesUtilMethods.getUniquePairsAsStream(edgesOfFeedbackLoop).anyMatch(edgePair -> this.crossingEdgesFound((Pair<ElkEdge, ElkEdge>)edgePair));
    }

    private boolean crossingEdgesFound(Pair<ElkEdge, ElkEdge> edgePair) {
        if (this.edgesCross(edgePair) && !this.haveSameSourceAndTargetNode(edgePair)) {
            this.crossingPairOfEdges = edgePair;
            return true;
        }
        return false;
    }

    private boolean edgesCross(Pair<ElkEdge, ElkEdge> edgePair) {
        return this.nodeLabelEdgeIntersection.edgesCross(edgePair.getFirst(), edgePair.getSecond());
    }

    private boolean haveSameSourceAndTargetNode(Pair<ElkEdge, ElkEdge> edgePair) {
        return edgePair.getFirst().hasSameSourceAndTargetNodeAs(edgePair.getSecond());
    }

    private String getErrorMsgFromFoundCrossingEdges() {
        return String.valueOf(MesUtilMethods.getDescription(this.crossingPairOfEdges.getFirst())) + " crosses " + MesUtilMethods.getDescription(this.crossingPairOfEdges.getSecond());
    }

    class ElkGraphAdapter
    implements IGraphAdapter<ElkNode> {
        private ElkNode graph;

        ElkGraphAdapter(ElkNode graph) {
            this.graph = graph;
        }

        @Override
        public List<ElkNode> getNodes() {
            return this.graph.getChildren();
        }

        @Override
        public List<IGraphAdapter.Edge<ElkNode>> getEdges() {
            ArrayList edges = Lists.newArrayList();
            this.graph.getContainedEdges().forEach(elkEdge -> {
                boolean bl = edges.add(new IGraphAdapter.Edge<ElkNode>(ElkGraphUtil.getSourceNode(elkEdge), ElkGraphUtil.getTargetNode(elkEdge)));
            });
            return edges;
        }
    }
}

