/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.alg.layered.mestestutils.NodeLabelEdgeIntersection;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import java.util.stream.Stream;

public class CrossingInEdgeNotComingFromInportBlock {
    private ElkNode graph;

    public CrossingInEdgeNotComingFromInportBlock(ElkNode graph) {
        this.graph = graph;
    }

    public String getErrorMsg() {
        ElkEdge foundEdge = this.getEdgesNotComingFromInportBlocks().filter(this::edgeIsCrossed).findFirst().orElse(null);
        return foundEdge == null ? "" : CrossingInEdgeNotComingFromInportBlock.getErrorMsg(foundEdge);
    }

    private Stream<ElkEdge> getEdgesNotComingFromInportBlocks() {
        return this.getNonInportBlocks().flatMap(n -> n.getPorts().stream().flatMap(p -> p.getOutgoingEdges().stream()));
    }

    private Stream<ElkNode> getNonInportBlocks() {
        return this.graph.getChildren().stream().filter(node -> !CrossingInEdgeNotComingFromInportBlock.isInportBlock(node));
    }

    private static boolean isInportBlock(ElkNode node) {
        return node.getProperty(CoreOptions.MES_BLOCK_PARAMETERS_MAP).getMap().get("BlockType").equals("Inport");
    }

    private boolean edgeIsCrossed(ElkEdge edge) {
        return new NodeLabelEdgeIntersection(this.graph).edgeIsCrossed(edge);
    }

    private static String getErrorMsg(ElkEdge foundEdge) {
        return "Unexpected crossing in " + MesUtilMethods.getDescription(foundEdge);
    }
}

