/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.util.ElkGraphUtil;
import com.modelengineers.MoRe_emf.common.util.EList;
import java.util.List;

public class CrossingEdges {
    private ElkNode graph;

    public CrossingEdges(ElkNode graph) {
        this.graph = graph;
    }

    public boolean multipleVerticalCrossingsOfNonBranchedEdges() {
        EList<ElkEdge> allEdges = this.graph.getContainedEdges();
        int i = 0;
        while (i < allEdges.size()) {
            int j = i + 1;
            while (j < allEdges.size()) {
                if (this.isMultipleVerticalCrossingOfOnlyEdgeOfPort((ElkEdge)allEdges.get(i), (ElkEdge)allEdges.get(j))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean isMultipleVerticalCrossingOfOnlyEdgeOfPort(ElkEdge edge1, ElkEdge edge2) {
        return this.countVerticalCrossings(edge1, edge2) > 1 && this.isOnlyEdgeConnectedToSrcOf(edge1) || this.countVerticalCrossings(edge2, edge1) > 1 && this.isOnlyEdgeConnectedToSrcOf(edge2);
    }

    private int countVerticalCrossings(ElkEdge edge1, ElkEdge edge2) {
        int numVerticalCrossings = 0;
        List<ElkUtil.Segment> segmentsOfEdge1 = ElkUtil.getSegments(edge1);
        List<ElkUtil.Segment> segmentsOfEdge2 = ElkUtil.getSegments(edge2);
        int i = 0;
        while (i < segmentsOfEdge1.size()) {
            int j = 0;
            while (j < segmentsOfEdge2.size()) {
                if (segmentsOfEdge1.get(i).crosses(segmentsOfEdge2.get(j)) && segmentsOfEdge1.get(i).isVertical()) {
                    ++numVerticalCrossings;
                }
                ++j;
            }
            ++i;
        }
        return numVerticalCrossings;
    }

    private boolean isOnlyEdgeConnectedToSrcOf(ElkEdge edge) {
        return ElkGraphUtil.getSourcePort(edge).getOutgoingEdges().size() == 1;
    }
}

