/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.mestestutils;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.core.util.ElkUtil;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ClawLikeRoutedEdgeToTopPort {
    private ElkNode graph;

    public ClawLikeRoutedEdgeToTopPort(ElkNode graph) {
        this.graph = graph;
    }

    public List<String> getNodesWithTopPortClaw() {
        List<ElkPort> topPortsToCheck = this.getTopPortsToCheckForClawLikeRoutedIncomingEdge();
        return this.getNodesWithTopPortClaw(topPortsToCheck);
    }

    private List<ElkPort> getTopPortsToCheckForClawLikeRoutedIncomingEdge() {
        return this.graph.getChildren().stream().flatMap(node -> this.getTopPortsToCheck((ElkNode)node)).collect(Collectors.toList());
    }

    private Stream<ElkPort> getTopPortsToCheck(ElkNode node) {
        return node.getPorts().stream().filter(port -> this.isTopPortToCheck((ElkPort)port));
    }

    private boolean isTopPortToCheck(ElkPort port) {
        return this.isTopPort(port) && this.hasOnlyOneIngoingEdge(port);
    }

    private boolean isTopPort(ElkPort port) {
        return port.getY() <= 0.0;
    }

    private boolean hasOnlyOneIngoingEdge(ElkPort port) {
        return port.getIncomingEdges().size() == 1 && port.getOutgoingEdges().size() == 0;
    }

    private List<String> getNodesWithTopPortClaw(List<ElkPort> topPortsToCheck) {
        ArrayList nodesWithTopPortClaw = Lists.newArrayList();
        for (ElkPort topPortToCheck : topPortsToCheck) {
            if (!this.incomingEdgeIsClawLikeRouted(topPortToCheck)) continue;
            nodesWithTopPortClaw.add(topPortToCheck.getParent().toString());
        }
        return nodesWithTopPortClaw.isEmpty() ? null : nodesWithTopPortClaw;
    }

    private boolean incomingEdgeIsClawLikeRouted(ElkPort topPortToCheck) {
        ElkEdge incomingEdge = (ElkEdge)topPortToCheck.getIncomingEdges().get(0);
        return this.isClawLikeRouted(incomingEdge);
    }

    private boolean isClawLikeRouted(ElkEdge incomingEdge) {
        List<ElkUtil.Segment> segmentsOfLine = ElkUtil.getSegments(incomingEdge);
        return this.areAtLeastFourSegments(segmentsOfLine) && this.lastFourSegmentsFormClaw(segmentsOfLine);
    }

    private boolean areAtLeastFourSegments(List<ElkUtil.Segment> segmentsOfLine) {
        return segmentsOfLine.size() > 3;
    }

    private boolean lastFourSegmentsFormClaw(List<ElkUtil.Segment> segmentsOfLine) {
        List<ElkUtil.Segment> lastFourSegments = this.getLastFourSegments(segmentsOfLine);
        return this.formClaw(lastFourSegments);
    }

    private List<ElkUtil.Segment> getLastFourSegments(List<ElkUtil.Segment> segmentsOfLine) {
        int numOfSegments = segmentsOfLine.size();
        return segmentsOfLine.subList(numOfSegments - 4, numOfSegments);
    }

    private boolean formClaw(List<ElkUtil.Segment> lastFourSegments) {
        ElkUtil.Segment fourthLastSegment = lastFourSegments.get(0);
        ElkUtil.Segment thirdLastSegment = lastFourSegments.get(1);
        ElkUtil.Segment secondLastSegment = lastFourSegments.get(2);
        ElkUtil.Segment lastSegment = lastFourSegments.get(3);
        return fourthLastSegment.isHorizontal() && thirdLastSegment.isVertical() && thirdLastSegment.runsUpwards() && secondLastSegment.isHorizontal() && lastSegment.isVertical();
    }
}

