/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayerConstraint;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.options.SizeConstraint;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class WideNodeSplitter {
    private final double dummyNodeWidth = 30.0;
    private final double thresholdWidthForWideNode;
    private final LGraph lGraph;
    private final List<LNode> addedDummyNodes = Lists.newArrayList();

    public WideNodeSplitter(LGraph layeredGraph) {
        this.lGraph = layeredGraph;
        this.thresholdWidthForWideNode = 30.0 + this.lGraph.getProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS);
    }

    public void splitNodes() {
        ArrayList nodes = Lists.newArrayList(this.lGraph.getLayerlessNodes());
        nodes.forEach(node -> this.splitNode((LNode)node));
    }

    public void splitNode(LNode wideNodeToSplit) {
        this.addedDummyNodes.clear();
        if (this.isSplittableWideNode(wideNodeToSplit)) {
            this.lGraph.getOriginalWideNodes().add(wideNodeToSplit);
            this.splitNodeIntoDummies(wideNodeToSplit);
            this.lGraph.getLayerlessNodes().addAll(this.addedDummyNodes);
            this.lGraph.getLayerlessNodes().remove(wideNodeToSplit);
        }
    }

    public boolean isSplittableWideNode(LNode wideNodeToSplit) {
        boolean hasNoComment;
        boolean hasNoBottomPorts = !wideNodeToSplit.getPorts(PortSide.SOUTH).iterator().hasNext();
        boolean hasNoTopPortsWithOutgoingEdges = wideNodeToSplit.getPortsAsList(PortSide.NORTH).stream().allMatch(p -> p.getOutgoingEdges().isEmpty());
        boolean hasNoSelfLoops = wideNodeToSplit.getPorts().stream().noneMatch(p -> p.getConnectedPortsAsList().stream().anyMatch(cp -> cp.getNode() == p.getNode()));
        boolean hasNoLayerConstraints = wideNodeToSplit.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT) == LayerConstraint.NONE;
        boolean hasNoTopPortsWithUnfixedPos = wideNodeToSplit.getPortsAsList(PortSide.NORTH).stream().noneMatch(p -> p.getNode().getProperty(LayeredOptions.PORT_CONSTRAINTS) != PortConstraints.FIXED_POS);
        boolean hasNoModelOrder = !wideNodeToSplit.hasProperty(InternalProperties.MODEL_ORDER);
        EnumSet<SizeConstraint> sizeConstraint = wideNodeToSplit.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        boolean sizeConstraintsFixed = sizeConstraint.isEmpty() || sizeConstraint.equals(EnumSet.of(SizeConstraint.PORT_LABELS));
        boolean isCommentBox = wideNodeToSplit.getProperty(LayeredOptions.COMMENT_BOX);
        boolean containsTopComment = wideNodeToSplit.getProperty(InternalProperties.TOP_COMMENTS) != null;
        boolean containsBottomComment = wideNodeToSplit.getProperty(InternalProperties.BOTTOM_COMMENTS) != null;
        boolean bl = hasNoComment = !isCommentBox && !containsTopComment && !containsBottomComment;
        return wideNodeToSplit.getSize().x > this.thresholdWidthForWideNode && hasNoBottomPorts && hasNoTopPortsWithUnfixedPos && hasNoTopPortsWithOutgoingEdges && hasNoSelfLoops && hasNoLayerConstraints && hasNoModelOrder && sizeConstraintsFixed && hasNoComment;
    }

    private void splitNodeIntoDummies(LNode wideNodeToSplit) {
        int numNodes = (int)Math.ceil(wideNodeToSplit.getSize().x / this.thresholdWidthForWideNode);
        this.addFirstDummyNode(wideNodeToSplit);
        int minimumNumberOfConnectionsBetweenDummyNodes = 10;
        int numberOfConnectionsBetweenDummyNodes = Math.max(10, wideNodeToSplit.getPorts().size() + 1);
        int idx = 1;
        while (idx < numNodes - 1) {
            this.addIntermediateDummyNode(wideNodeToSplit, numberOfConnectionsBetweenDummyNodes);
            ++idx;
        }
        double remainingWideNodeWidth = wideNodeToSplit.getSize().x - (double)(numNodes - 1) * this.thresholdWidthForWideNode;
        this.addLastDummyNode(wideNodeToSplit, remainingWideNodeWidth, numberOfConnectionsBetweenDummyNodes);
        this.transferTopPorts(wideNodeToSplit);
        this.setProperties(wideNodeToSplit);
    }

    private void addFirstDummyNode(LNode wideNodeToSplit) {
        LNode dummyNode = this.createWideNodeDummyNodeOfWidth(wideNodeToSplit, 30.0);
        this.transferPortsOnSide(wideNodeToSplit, dummyNode, PortSide.WEST);
        this.addedDummyNodes.add(dummyNode);
    }

    private void addIntermediateDummyNode(LNode wideNodeToSplit, int numberOfConnectionsBetweenDummyNodes) {
        LNode dummyNode = this.createWideNodeDummyNodeOfWidth(wideNodeToSplit, 30.0);
        this.connectToPreviouslyAddedDummyNode(dummyNode, numberOfConnectionsBetweenDummyNodes);
        this.addedDummyNodes.add(dummyNode);
    }

    private void addLastDummyNode(LNode wideNodeToSplit, double remainingWideNodeWidth, int numberOfConnectionsBetweenDummyNodes) {
        LNode dummyNode = this.createWideNodeDummyNodeOfWidth(wideNodeToSplit, remainingWideNodeWidth);
        this.connectToPreviouslyAddedDummyNode(dummyNode, numberOfConnectionsBetweenDummyNodes);
        this.transferPortsOnSide(wideNodeToSplit, dummyNode, PortSide.EAST);
        this.addedDummyNodes.add(dummyNode);
    }

    private LNode createWideNodeDummyNodeOfWidth(LNode wideNodeToSplit, double width) {
        LNode wideNodeDummyNode = new LNode(this.lGraph);
        wideNodeDummyNode.setType(LNode.NodeType.WIDE_NODE);
        wideNodeDummyNode.setOriginalWideNode(wideNodeToSplit);
        wideNodeDummyNode.getSize().x = width;
        wideNodeDummyNode.getSize().y = wideNodeToSplit.getSize().y;
        return wideNodeDummyNode;
    }

    private void transferPortsOnSide(LNode wideNodeToSplit, LNode dummyNode, PortSide portSide) {
        wideNodeToSplit.getPortsAsList(portSide).forEach(p -> this.transferPortOnSide((LPort)p, dummyNode));
    }

    private void transferPortOnSide(LPort port, LNode dummyNode) {
        double xPosition = port.getPosition().x;
        if (port.getSide() == PortSide.EAST && xPosition != 0.0) {
            xPosition = xPosition - port.getNode().getSize().x + dummyNode.getSize().x;
        }
        port.setNode(dummyNode);
        port.getPosition().x = xPosition;
    }

    private void connectToPreviouslyAddedDummyNode(LNode dummyNode, int numberOfConnectionsBetweenDummyNodes) {
        LNode previouslyAddedDummyNode = this.addedDummyNodes.get(this.addedDummyNodes.size() - 1);
        List<LPort> srcPorts = this.addPortsForConnections(previouslyAddedDummyNode, numberOfConnectionsBetweenDummyNodes);
        List<LPort> dstPorts = this.addPortsForConnections(dummyNode, numberOfConnectionsBetweenDummyNodes);
        WideNodeSplitter.addEdgesBetweenPorts(srcPorts, dstPorts);
    }

    private List<LPort> addPortsForConnections(LNode dummyNode, int numberOfConnectionsBetweenDummyNodes) {
        ArrayList lPorts = Lists.newArrayList();
        int ix = 0;
        while (ix < numberOfConnectionsBetweenDummyNodes) {
            LPort newPort = new LPort();
            newPort.setProperty(InternalProperties.WIDE_NODE_INNER_PORT, (Object)true);
            newPort.setNode(dummyNode);
            lPorts.add(newPort);
            ++ix;
        }
        return lPorts;
    }

    private static void addEdgesBetweenPorts(List<LPort> srcPorts, List<LPort> dstPorts) {
        int numOfPorts = srcPorts.size();
        int ix = 0;
        while (ix < numOfPorts) {
            LEdge edge = new LEdge();
            edge.setSource(srcPorts.get(ix));
            edge.setTarget(dstPorts.get(numOfPorts - ix - 1));
            ++ix;
        }
    }

    private void transferTopPorts(LNode wideNodeToSplit) {
        wideNodeToSplit.getPortsAsList(PortSide.NORTH).forEach(p -> {
            LNode lNode = WideNodeSplitter.transferTopPort(p, this.addedDummyNodes, new KVector(p.getPosition()), this.thresholdWidthForWideNode);
        });
    }

    public static LNode transferTopPort(LPort topPort, List<LNode> dummyNodes, KVector posOfTopPort, double effDummyWidth) {
        Pair<LNode, Double> newNodeAndXPosForTopPort = WideNodeSplitter.getDummyNodeForTopPort(dummyNodes, topPort, posOfTopPort.x, effDummyWidth);
        topPort.setProperty(InternalProperties.ORIGINAL_PORT_POSITION, posOfTopPort);
        WideNodeSplitter.setTopPortToNode(topPort, posOfTopPort.y, newNodeAndXPosForTopPort);
        return newNodeAndXPosForTopPort.getFirst();
    }

    private static Pair<LNode, Double> getDummyNodeForTopPort(List<LNode> dummyNodes, LPort topPort, double xPosOfTopPort, double effDummyWidth) {
        int dummyNodeIx = 0;
        double widthOfDummyNodes = effDummyWidth;
        while (widthOfDummyNodes <= xPosOfTopPort) {
            ++dummyNodeIx;
            widthOfDummyNodes += effDummyWidth;
        }
        return Pair.of(dummyNodes.get(dummyNodeIx), xPosOfTopPort - (widthOfDummyNodes - effDummyWidth));
    }

    private static void setTopPortToNode(LPort topPort, double yPosTopPort, Pair<LNode, Double> newNodeAndXPosForTopPort) {
        topPort.setNode(newNodeAndXPosForTopPort.getFirst());
        topPort.getPosition().set(new KVector(newNodeAndXPosForTopPort.getSecond(), yPosTopPort));
    }

    private void setProperties(LNode wideNodeToSplit) {
        for (LNode dummyNode : this.addedDummyNodes) {
            dummyNode.copyProperties(wideNodeToSplit);
            dummyNode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)wideNodeToSplit.getProperty(CoreOptions.PORT_CONSTRAINTS));
        }
        wideNodeToSplit.setWideNodeDummies(Lists.newArrayList(this.addedDummyNodes));
    }
}

