/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.math.ElkMath;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.math.KVectorChain;
import com.modelengineers.MoRe_elk.core.options.Alignment;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class WideNodeJoiner {
    private LGraph lgraph;
    private KVector absoluteTopPortPosition;
    private List<ElkRectangle> allNodeRectangles = Lists.newArrayList();
    private List<Pair<LNode, KVectorChain>> allVerticalEdgeSegments = Lists.newArrayList();
    private List<Pair<LNode, KVectorChain>> allHorizontalEdgeSegments = Lists.newArrayList();
    private List<Pair<LNode, KVector>> nodesWithTopPortWithLeftAlignmentPos = Lists.newArrayList();

    public WideNodeJoiner(LGraph layeredGraph) {
        this.lgraph = layeredGraph;
    }

    public void joinNodes() {
        this.lgraph.getOriginalWideNodes().forEach(n -> this.joinNode((LNode)n));
        this.positionOriginalNodesWithTopPortAccordingToLeftAlignment();
    }

    private void joinNode(LNode originalWideNode) {
        LNode firstDummyNode = originalWideNode.getWideNodeDummies().get(0);
        LNode lastDummyNode = originalWideNode.getWideNodeDummies().get(originalWideNode.getWideNodeDummies().size() - 1);
        List<LPort> topPorts = this.getTopPorts(originalWideNode.getWideNodeDummies());
        List<LPort> westPortsOfFirstWideNode = firstDummyNode.getPortsAsList(PortSide.WEST);
        List<LPort> eastPortsOfLastWideNode = lastDummyNode.getPortsAsList(PortSide.EAST);
        this.transferPorts(westPortsOfFirstWideNode, eastPortsOfLastWideNode, topPorts, originalWideNode, lastDummyNode);
        this.positionOriginalWideNodeAccordingToPorts(originalWideNode, topPorts);
        this.restoreOriginalNodeInGraph(originalWideNode, firstDummyNode);
    }

    private List<LPort> getTopPorts(List<LNode> wideNodeDummys) {
        ArrayList topPorts = Lists.newArrayList();
        topPorts.addAll(wideNodeDummys.stream().map(n -> n.getPortsAsList(PortSide.NORTH)).flatMap(Collection::stream).collect(Collectors.toList()));
        return topPorts;
    }

    private void transferPorts(List<LPort> westPorts, List<LPort> eastPorts, List<LPort> topPorts, LNode originalWideNode, LNode lastDummyNode) {
        westPorts.forEach(port -> port.setNode(originalWideNode));
        eastPorts.forEach(port -> port.setNode(originalWideNode));
        eastPorts.forEach(port -> {
            double d = port.getPosition().x = port.getPosition().x - lNode.getSize().x + lNode2.getSize().x;
        });
        topPorts.forEach(topPort -> this.transferTopPort((LPort)topPort, originalWideNode));
    }

    private void transferTopPort(LPort topPort, LNode originalWideNode) {
        this.absoluteTopPortPosition = new KVector(topPort.getPosition().x + topPort.getNode().getPosition().x, topPort.getPosition().y + topPort.getNode().getPosition().y);
        topPort.setNode(originalWideNode);
        topPort.getPosition().set(topPort.getProperty(InternalProperties.ORIGINAL_PORT_POSITION));
    }

    private void positionOriginalWideNodeAccordingToPorts(LNode originalWideNode, List<LPort> topPorts) {
        LNode firstNode = originalWideNode.getWideNodeDummies().get(0);
        KVector posForOriginalNode = firstNode.getPosition().clone();
        if (originalWideNode.getProperty(LayeredOptions.ALIGNMENT) == Alignment.RIGHT && topPorts.isEmpty()) {
            LNode lastNodeWithNonLabelPart = originalWideNode.getWideNodeDummies().get(0).getLastNonLabelWideNodeDummy();
            posForOriginalNode.x = lastNodeWithNonLabelPart.getPosition().x - originalWideNode.getSize().x + originalWideNode.getLabelMargin().right + lastNodeWithNonLabelPart.getSize().x - lastNodeWithNonLabelPart.getRightLabelWidth();
        } else {
            LNode firstNodeWithNonLabelPart = originalWideNode.getWideNodeDummies().get(0).getFirstNonLabelOfWideNodes();
            posForOriginalNode.x = firstNodeWithNonLabelPart.getPosition().x + firstNodeWithNonLabelPart.getLeftLabelWidth() - originalWideNode.getLabelMargin().left;
        }
        if (topPorts.isEmpty()) {
            originalWideNode.getPosition().set(posForOriginalNode);
        } else {
            if (this.topPortsHaveSuitableConnection(topPorts)) {
                this.nodesWithTopPortWithLeftAlignmentPos.add(Pair.of(originalWideNode, posForOriginalNode));
            }
            this.positionWideNodeAccordingToTopPort(originalWideNode, topPorts);
        }
    }

    private boolean topPortsHaveSuitableConnection(List<LPort> topPorts) {
        return topPorts.stream().anyMatch(p -> !p.hasOutgoingEdges() && p.hasIncomingEdges());
    }

    private void positionWideNodeAccordingToTopPort(LNode originalWideNode, List<LPort> topPorts) {
        KVector newPos = this.absoluteTopPortPosition.sub(topPorts.get(topPorts.size() - 1).getPosition());
        originalWideNode.getPosition().set(newPos);
    }

    private void restoreOriginalNodeInGraph(LNode originalNode, LNode firstWideNode) {
        if (firstWideNode.getLayer() == null) {
            firstWideNode.getGraph().getLayerlessNodes().add(originalNode);
            firstWideNode.getGraph().getLayerlessNodes().removeAll(originalNode.getWideNodeDummies());
        } else {
            originalNode.setLayer(firstWideNode.getLayer());
            originalNode.getWideNodeDummies().forEach(node -> node.setLayer(null));
        }
    }

    private void positionOriginalNodesWithTopPortAccordingToLeftAlignment() {
        if (!this.nodesWithTopPortWithLeftAlignmentPos.isEmpty()) {
            this.setAllNodeRectanglesAndEdgeSegments();
            this.nodesWithTopPortWithLeftAlignmentPos.forEach(n -> this.positionOriginalNodeWithTopPortAccordingToLeftAlignment((Pair<LNode, KVector>)n));
        }
    }

    private void setAllNodeRectanglesAndEdgeSegments() {
        List<LNode> nodes = this.lgraph.getNodesFromAllLayers();
        nodes.forEach(n -> this.setNodeRectanglesAndEdgeSegments((LNode)n));
    }

    private void setNodeRectanglesAndEdgeSegments(LNode n) {
        this.allNodeRectangles.add(new ElkRectangle(this.getLeftBorderOfNodeIncludingPorts(n), n.getPosition().y, this.getRightBorderOfNodeIncludingPorts(n) - this.getLeftBorderOfNodeIncludingPorts(n), n.getSize().y));
        this.setEdgeSegments(n);
    }

    private double getLeftBorderOfNodeIncludingPorts(LNode node) {
        double leftBorderX = node.getPosition().x;
        for (LPort port : node.getPorts(PortSide.WEST)) {
            leftBorderX = Math.min(port.getAbsoluteAnchor().x, leftBorderX);
        }
        return leftBorderX;
    }

    private double getRightBorderOfNodeIncludingPorts(LNode node) {
        double rightBorderX = node.getPosition().x + node.getSize().x;
        for (LPort port : node.getPorts(PortSide.EAST)) {
            rightBorderX = Math.max(port.getAbsoluteAnchor().x, rightBorderX);
        }
        return rightBorderX;
    }

    private void setEdgeSegments(LNode n) {
        for (LEdge e : n.getOutgoingEdges()) {
            KVectorChain edgePoints = new KVectorChain(e.getBendPoints());
            KVector edgeSrcPortAbsPos = KVector.sum(e.getSource().getPosition(), e.getSourceNode().getPosition());
            KVector edgeTrgPortAbsPos = KVector.sum(e.getTarget().getPosition(), e.getTargetNode().getPosition());
            edgePoints.addFirst(edgeSrcPortAbsPos);
            edgePoints.addLast(edgeTrgPortAbsPos);
            int numOfEdgePoints = edgePoints.size();
            int i = 0;
            while (i < numOfEdgePoints - 1) {
                KVector p1 = (KVector)edgePoints.get(i);
                KVector p2 = (KVector)edgePoints.get(i + 1);
                if (p1.y != p2.y) {
                    this.allVerticalEdgeSegments.add(Pair.of(e.getTargetNode(), new KVectorChain(p1, p2)));
                }
                if (p1.x != p2.x) {
                    this.allHorizontalEdgeSegments.add(Pair.of(e.getTargetNode(), new KVectorChain(p1, p2)));
                }
                ++i;
            }
        }
    }

    private void positionOriginalNodeWithTopPortAccordingToLeftAlignment(Pair<LNode, KVector> nodeWithTopPortWithLeftAlignmentPos) {
        KVector posAccordingToLeftAlignment;
        LNode node = nodeWithTopPortWithLeftAlignmentPos.getFirst();
        List<LPort> topPorts = node.getPortsAsList(PortSide.NORTH);
        if (this.isSpaceAvailableToMoveNode(topPorts, posAccordingToLeftAlignment = nodeWithTopPortWithLeftAlignmentPos.getSecond())) {
            node.getPosition().set(posAccordingToLeftAlignment);
        }
        this.correctEdgeRoutingOfTopPorts(topPorts);
    }

    private boolean isSpaceAvailableToMoveNode(List<LPort> topPorts, KVector posAccordingToLeftAlignment) {
        return !this.topPortIncomingEdgeWouldBeTooCloseToOtherNode(topPorts, posAccordingToLeftAlignment) && !this.topPortIncomingEdgeWouldBeTooCloseToOtherEdge(topPorts, posAccordingToLeftAlignment);
    }

    private boolean topPortIncomingEdgeWouldBeTooCloseToOtherNode(List<LPort> topPorts, KVector posAccordingToLeftAlignment) {
        ElkRectangle rectangleToCheckForIntersection = new ElkRectangle();
        double margin = CoreOptions.SPACING_EDGE_NODE.getDefault();
        for (LPort p : topPorts) {
            LEdge incomingEdge = p.getIncomingEdges().get(0);
            double x = posAccordingToLeftAlignment.x + p.getPosition().x - margin;
            double y = ((KVector)incomingEdge.getBendPoints().getLast()).y;
            double w = margin * 2.0;
            double h = posAccordingToLeftAlignment.y + p.getPosition().y - y;
            if (rectangleToCheckForIntersection.width == 0.0) {
                rectangleToCheckForIntersection.setRect(x, y, w, h);
                continue;
            }
            rectangleToCheckForIntersection.union(new ElkRectangle(x, y, w, h));
        }
        if (rectangleToCheckForIntersection.width != 0.0) {
            return this.allNodeRectangles.stream().anyMatch(r -> r.intersects(rectangleToCheckForIntersection));
        }
        return false;
    }

    private boolean topPortIncomingEdgeWouldBeTooCloseToOtherEdge(List<LPort> topPorts, KVector posAccordingToLeftAlignment) {
        double margin = CoreOptions.SPACING_EDGE_EDGE.getDefault();
        LNode topPortNode = topPorts.get(0).getNode();
        for (LPort p : topPorts) {
            LEdge incomingEdge = p.getIncomingEdges().get(0);
            double startXPos = p.getPosition().x + posAccordingToLeftAlignment.x;
            double startYPos = ((KVector)incomingEdge.getBendPoints().getLast()).y;
            double endYPos = p.getPosition().y + posAccordingToLeftAlignment.y;
            ElkRectangle edgeRectangleAfterLeftAlignment = new ElkRectangle(startXPos - margin, startYPos, margin * 2.0, endYPos - startYPos);
            if (!this.allVerticalEdgeSegments.stream().anyMatch(s -> !topPortNode.equals(s.getFirst()) && ElkMath.intersects(edgeRectangleAfterLeftAlignment, (KVectorChain)s.getSecond()))) continue;
            return true;
        }
        return false;
    }

    private void correctEdgeRoutingOfTopPorts(List<LPort> topPorts) {
        for (LPort topPort : topPorts) {
            double newXPos = topPort.getPosition().x + topPort.getNode().getPosition().x + topPort.getAnchor().x;
            topPort.getConnectedEdges().forEach(e -> this.correctBendPoint((LEdge)e, newXPos, e.getTarget() == topPort, topPort));
        }
    }

    private void correctBendPoint(LEdge edge, double newXPos, boolean isIncomingEdge, LPort topPort) {
        KVectorChain bendPoints = edge.getBendPoints();
        if (!bendPoints.isEmpty()) {
            KVector bendPointToCorrect = !isIncomingEdge ? (KVector)bendPoints.getFirst() : (KVector)bendPoints.getLast();
            bendPointToCorrect.x = newXPos;
        }
        if (isIncomingEdge) {
            this.correctJunctionAndBendPoints(edge, newXPos, topPort);
        }
    }

    private void correctJunctionAndBendPoints(LEdge edge, double topPortAbsXPos, LPort topPort) {
        KVectorChain bendPoints = edge.getBendPoints();
        List junctionPoints = edge.getProperty(LayeredOptions.JUNCTION_POINTS);
        double edgeEdgeSpacing = this.lgraph.getProperty(LayeredOptions.SPACING_EDGE_EDGE_OR_EDGE_NODE_BETWEEN_LAYERS_ADAPTIVE_LOWER_BOUND);
        int numOfBendPointsToCheck = 3;
        if (!junctionPoints.isEmpty()) {
            this.correctBendAndJunctionPointsOfJunctions(edge, topPortAbsXPos, topPort, bendPoints, junctionPoints, edgeEdgeSpacing, 3);
        } else {
            this.correctBendPointsOfSimpleEdge(edge, bendPoints, edgeEdgeSpacing, 3);
        }
    }

    private void correctBendAndJunctionPointsOfJunctions(LEdge edge, double topPortAbsXPos, LPort topPort, KVectorChain bendPoints, List<KVector> junctionPoints, double edgeEdgeSpacing, int numOfBendPointsToCheck) {
        KVector[] lastThreeBendPoints;
        ElkRectangle edgeRectangleAfterBendPointCorrection;
        KVector correctableJunctionPoint = this.getCorrectableJunctionPoint(bendPoints, junctionPoints);
        if (correctableJunctionPoint != null && !this.rectIntersectsOtherNodesOrIsTooCloseToOtherParallelEdgeSections(topPort, edgeRectangleAfterBendPointCorrection = this.getRectangleAfterBendPointCorrection(lastThreeBendPoints = bendPoints.toArray(bendPoints.size() - numOfBendPointsToCheck), topPortAbsXPos, edgeEdgeSpacing), this.allVerticalEdgeSegments) && this.newJunctionPointLiesOnOneOfEdgeBranchesFromSameSource(edge, topPortAbsXPos, correctableJunctionPoint.y) && this.minDistanceBetweenBendPointsOnEdgesConnectedToSameSourceIsMaintained(lastThreeBendPoints[0], topPortAbsXPos, edge)) {
            lastThreeBendPoints[0].x = topPortAbsXPos;
            correctableJunctionPoint.x = topPortAbsXPos;
            bendPoints.remove(lastThreeBendPoints[1]);
            bendPoints.remove(lastThreeBendPoints[2]);
        }
    }

    private ElkRectangle getRectangleAfterBendPointCorrection(KVector[] lastThreeBendPoints, double topPortAbsXPos, double edgeEdgeSpacing) {
        double startXPos = topPortAbsXPos;
        double startYPos = lastThreeBendPoints[0].y;
        double endYPos = lastThreeBendPoints[1].y;
        double yPosOfBendPointCorrectionRect = startYPos < endYPos ? startYPos : endYPos;
        double heightOfBendPointCorrectionRect = Math.abs(endYPos - startYPos);
        return new ElkRectangle(startXPos - edgeEdgeSpacing, yPosOfBendPointCorrectionRect, edgeEdgeSpacing * 2.0, heightOfBendPointCorrectionRect);
    }

    private KVector getCorrectableJunctionPoint(KVectorChain bendPoints, List<KVector> junctionPoints) {
        KVector correctableJunctionPoint = null;
        int numOfBendPointsToCheck = 3;
        if (bendPoints.size() >= 3) {
            KVector thirdLastBendPoint = (KVector)bendPoints.get(bendPoints.size() - 3);
            List correctableJunctionPoints = junctionPoints.stream().filter(p -> p.equals(thirdLastBendPoint)).collect(Collectors.toList());
            if (!correctableJunctionPoints.isEmpty()) {
                correctableJunctionPoint = (KVector)correctableJunctionPoints.get(0);
            }
        }
        return correctableJunctionPoint;
    }

    private boolean newJunctionPointLiesOnOneOfEdgeBranchesFromSameSource(LEdge edgeToTopPort, double bendPointNewXPos, double bendPointNewYPos) {
        ElkRectangle dummyRectForNewJunctionPoint = new ElkRectangle(bendPointNewXPos - 1.0, bendPointNewYPos - 1.0, 2.0, 2.0);
        return edgeToTopPort.getSource().getOutgoingEdges().stream().anyMatch(e -> !e.equals(edgeToTopPort) && ElkMath.intersects(dummyRectForNewJunctionPoint, this.getPointsOfEdge((LEdge)e)));
    }

    private boolean minDistanceBetweenBendPointsOnEdgesConnectedToSameSourceIsMaintained(KVector bendPointToBeChanged, double newBendPointXPos, LEdge edgeToTopPort) {
        KVector newBendPoint = new KVector(newBendPointXPos, bendPointToBeChanged.y);
        int minDistReq = 5;
        for (LEdge e : edgeToTopPort.getSource().getOutgoingEdges()) {
            for (KVector p : this.getPointsOfEdge(e)) {
                if (p.equals(bendPointToBeChanged) || !(p.distance(newBendPoint) <= 5.0)) continue;
                return false;
            }
        }
        return true;
    }

    private void correctBendPointsOfSimpleEdge(LEdge edge, KVectorChain bendPoints, double edgeEdgeSpacing, int numOfBendPointsToCheck) {
        if (bendPoints.size() == numOfBendPointsToCheck) {
            LPort targetPort;
            KVector[] bendPointsArray = bendPoints.toArray(0);
            LPort sourcePort = edge.getSource();
            if (this.validatePossibleBendPointReduction(sourcePort, targetPort = edge.getTarget(), edgeEdgeSpacing, bendPoints)) {
                bendPointsArray[0].x = bendPointsArray[2].x;
                bendPoints.remove(bendPointsArray[1]);
                bendPoints.remove(bendPointsArray[2]);
            }
        }
    }

    private boolean validatePossibleBendPointReduction(LPort sourcePort, LPort targetPort, double edgeEdgeSpacing, KVectorChain bendPoints) {
        KVector sourcePortPos = sourcePort.getAbsoluteAnchor();
        KVector targetPortPos = targetPort.getAbsoluteAnchor();
        return this.bendPointsAllowReduction(bendPoints) && this.horizontalEdgeDoesNotIntersect(sourcePortPos, targetPortPos, edgeEdgeSpacing, targetPort) && this.verticalEdgeDoesNotIntersect(sourcePortPos, targetPortPos, edgeEdgeSpacing, targetPort);
    }

    private boolean bendPointsAllowReduction(KVectorChain bendPoints) {
        return ((KVector)bendPoints.get((int)0)).y < ((KVector)bendPoints.get((int)1)).y && ((KVector)bendPoints.get((int)1)).x != ((KVector)bendPoints.get((int)2)).x;
    }

    private boolean horizontalEdgeDoesNotIntersect(KVector sourcePortPos, KVector targetPortPos, double edgeEdgeSpacing, LPort targetPort) {
        double maxX;
        double minX = Math.min(sourcePortPos.x, targetPortPos.x);
        ElkRectangle horizontalEdgeRectangleAfterBendPointCorrection = new ElkRectangle(minX, sourcePortPos.y - edgeEdgeSpacing, (maxX = Math.max(sourcePortPos.x, targetPortPos.x)) - minX, edgeEdgeSpacing * 2.0);
        return !this.rectIntersectsOtherNodesOrIsTooCloseToOtherParallelEdgeSections(targetPort, horizontalEdgeRectangleAfterBendPointCorrection, this.allHorizontalEdgeSegments);
    }

    private boolean verticalEdgeDoesNotIntersect(KVector sourcePortPos, KVector targetPortPos, double edgeEdgeSpacing, LPort targetPort) {
        ElkRectangle verticalEdgeRectangleAfterBendPointCorrection = new ElkRectangle(targetPortPos.x - edgeEdgeSpacing, sourcePortPos.y, edgeEdgeSpacing * 2.0, targetPortPos.y - sourcePortPos.y);
        return !this.rectIntersectsOtherNodesOrIsTooCloseToOtherParallelEdgeSections(targetPort, verticalEdgeRectangleAfterBendPointCorrection, this.allVerticalEdgeSegments);
    }

    private boolean rectIntersectsOtherNodesOrIsTooCloseToOtherParallelEdgeSections(LPort topPort, ElkRectangle edgeRectangleAfterBendPointCorrection, List<Pair<LNode, KVectorChain>> edgeSegments) {
        return edgeSegments.stream().anyMatch(s -> !topPort.getNode().equals(s.getFirst()) && (ElkMath.intersects(edgeRectangleAfterBendPointCorrection, (KVectorChain)s.getSecond()) || this.isIn(edgeRectangleAfterBendPointCorrection, (KVectorChain)s.getSecond()))) || this.allNodeRectangles.stream().anyMatch(r -> r.intersects(edgeRectangleAfterBendPointCorrection));
    }

    private boolean isIn(ElkRectangle rect, KVectorChain segment) {
        return rect.x < ((KVector)segment.getFirst()).x && rect.y < ((KVector)segment.getFirst()).y && rect.x + rect.width > ((KVector)segment.getLast()).x && rect.y + rect.height > ((KVector)segment.getLast()).y;
    }

    private KVectorChain getPointsOfEdge(LEdge edge) {
        KVectorChain points = new KVectorChain();
        points.add(this.getStartPosOfEdge(edge));
        for (KVector bendPoint : edge.getBendPoints()) {
            points.add(new KVector(bendPoint.x, bendPoint.y));
        }
        points.add(this.getEndPosOfEdge(edge));
        return points;
    }

    private KVector getStartPosOfEdge(LEdge edge) {
        LPort sourcePort = edge.getSource();
        return sourcePort.getAbsoluteAnchor();
    }

    private KVector getEndPosOfEdge(LEdge edge) {
        LPort targetPort = edge.getTarget();
        return targetPort.getAbsoluteAnchor();
    }
}

