/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.List;
import java.util.stream.Collectors;

public class WideNodeCrossingDetector {
    private List<Layer> layers;
    private LNode sourceWideNodeDummyOfCrossing;
    private List<Connection> connections;

    public boolean detect(LGraph lGraph) {
        this.sourceWideNodeDummyOfCrossing = null;
        this.layers = lGraph.getLayers();
        int layerIx = 0;
        while (layerIx < this.layers.size() - 1) {
            if (this.detectBetweenGivenAndFollowingLayer(layerIx)) {
                return true;
            }
            ++layerIx;
        }
        return false;
    }

    public LNode getSourceWideNodeDummyOfCrossing() {
        return this.sourceWideNodeDummyOfCrossing;
    }

    private boolean detectBetweenGivenAndFollowingLayer(int layerIx) {
        Layer leftLayer = this.layers.get(layerIx);
        Layer rightLayer = this.layers.get(layerIx + 1);
        return this.containsWideNode(leftLayer) && this.containsWideNode(rightLayer) && this.detectBetween(leftLayer, rightLayer);
    }

    private boolean containsWideNode(Layer layer) {
        return layer.getNodes().stream().anyMatch(n -> n.isWideNode());
    }

    private boolean detectBetween(Layer leftLayer, Layer rightLayer) {
        List<LPort> leftLayerEastPorts = this.getPortsSortedTopToBottom(leftLayer, PortSide.EAST);
        List<LPort> rightLayerWestPorts = this.getPortsSortedTopToBottom(rightLayer, PortSide.WEST);
        return this.detectBetween(leftLayerEastPorts, rightLayerWestPorts);
    }

    private List<LPort> getPortsSortedTopToBottom(Layer layer, PortSide portSide) {
        return layer.getNodes().stream().flatMap(n -> n.getPortsSortedTopToBottom(portSide).stream()).collect(Collectors.toList());
    }

    private boolean detectBetween(List<LPort> leftLayerEastPorts, List<LPort> rightLayerWestPorts) {
        this.connections = Lists.newArrayList();
        this.addConnections(leftLayerEastPorts, rightLayerWestPorts);
        return this.connections.stream().filter(c -> c.isWideNodeConnection()).anyMatch(c -> this.detectCrossings((Connection)c));
    }

    private void addConnections(List<LPort> leftLayerEastPorts, List<LPort> rightLayerWestPorts) {
        this.addConnectionsBetweenLayers(leftLayerEastPorts, rightLayerWestPorts);
        this.addInLayerConnections(leftLayerEastPorts, rightLayerWestPorts);
    }

    private void addConnectionsBetweenLayers(List<LPort> leftLayerEastPorts, List<LPort> rightLayerWestPorts) {
        int ixSrcPort = 0;
        for (LPort srcPort : leftLayerEastPorts) {
            for (LPort dstPort : srcPort.getConnectedPorts()) {
                int ixDstPort = rightLayerWestPorts.indexOf(dstPort);
                if (ixDstPort < 0) continue;
                if (srcPort.getNode().isWideNode() && dstPort.getNode().isWideNode() && srcPort.getNode().getOriginalWideNode() == dstPort.getNode().getOriginalWideNode()) {
                    this.addWideNodeConnection(ixSrcPort, ixDstPort, srcPort);
                    continue;
                }
                this.connections.add(new Connection(ixSrcPort, ixDstPort, srcPort, ConnectionType.NORMAL));
            }
            ++ixSrcPort;
        }
    }

    private void addWideNodeConnection(int ixSrcPort, int ixDstPort, LPort srcPort) {
        if (this.connections.stream().noneMatch(c -> ((Connection)c).sourcePort.getNode() == srcPort.getNode())) {
            this.connections.add(new Connection(ixSrcPort, ixDstPort, srcPort, ConnectionType.WIDENODE));
        }
    }

    private void addInLayerConnections(List<LPort> leftLayerEastPorts, List<LPort> rightLayerWestPorts) {
        this.addInLayerConnections(leftLayerEastPorts, ConnectionType.LEFTLAYER);
        this.addInLayerConnections(rightLayerWestPorts, ConnectionType.RIGHTLAYER);
    }

    private void addInLayerConnections(List<LPort> layerPortsOnOneSide, ConnectionType connectionType) {
        int ixSrcPort = 0;
        for (LPort port : layerPortsOnOneSide) {
            for (LPort dstPort : port.getSuccessorPorts()) {
                int ixDstPort = layerPortsOnOneSide.indexOf(dstPort);
                if (ixDstPort < 0) continue;
                this.connections.add(new Connection(ixSrcPort, ixDstPort, port, connectionType));
            }
            ++ixSrcPort;
        }
    }

    private boolean detectCrossings(Connection wideNodeConnection) {
        return this.connections.stream().anyMatch(c -> c != wideNodeConnection && this.detectBetween(wideNodeConnection, (Connection)c));
    }

    private boolean detectBetween(Connection wideNodeConnection, Connection connection) {
        if (this.connectionsCross(wideNodeConnection, connection)) {
            this.sourceWideNodeDummyOfCrossing = wideNodeConnection.sourcePort.getNode();
            return true;
        }
        return false;
    }

    private boolean connectionsCross(Connection wideNodeConnection, Connection connection) {
        switch (connection.connectionType) {
            case LEFTLAYER: {
                return this.wideNodeConnectionCrossesLeftInLayerConnection(wideNodeConnection, connection);
            }
            case RIGHTLAYER: {
                return this.wideNodeConnectionCrossesRightInLayerConnection(wideNodeConnection, connection);
            }
        }
        return this.wideNodeConnectionCrossesNormalConnection(wideNodeConnection, connection);
    }

    private boolean wideNodeConnectionCrossesLeftInLayerConnection(Connection wideNodeConnection, Connection inLayerConnection) {
        boolean sourceBelowSourceWideNode = inLayerConnection.ixSourcePort > wideNodeConnection.ixSourcePort;
        boolean targetBelowSourceWideNode = inLayerConnection.ixTargetPort > wideNodeConnection.ixSourcePort;
        return sourceBelowSourceWideNode ^ targetBelowSourceWideNode;
    }

    private boolean wideNodeConnectionCrossesRightInLayerConnection(Connection wideNodeConnection, Connection inLayerConnection) {
        boolean sourceBelowSourceWideNode = inLayerConnection.ixSourcePort > wideNodeConnection.ixTargetPort;
        boolean targetBelowSourceWideNode = inLayerConnection.ixTargetPort > wideNodeConnection.ixTargetPort;
        return sourceBelowSourceWideNode ^ targetBelowSourceWideNode;
    }

    private boolean wideNodeConnectionCrossesNormalConnection(Connection wideNodeConnection, Connection normalConnection) {
        boolean sourceBelowSourceWideNode = normalConnection.ixSourcePort > wideNodeConnection.ixSourcePort;
        boolean targetBelowTargetWideNode = normalConnection.ixTargetPort > wideNodeConnection.ixTargetPort;
        return sourceBelowSourceWideNode ^ targetBelowTargetWideNode;
    }

    private class Connection {
        private int ixSourcePort;
        private int ixTargetPort;
        private LPort sourcePort;
        private ConnectionType connectionType;

        Connection(int ixSourcePort, int ixTargetPort, LPort sourcePort, ConnectionType connectionType) {
            this.ixSourcePort = ixSourcePort;
            this.ixTargetPort = ixTargetPort;
            this.sourcePort = sourcePort;
            this.connectionType = connectionType;
        }

        boolean isWideNodeConnection() {
            return this.connectionType.equals((Object)ConnectionType.WIDENODE);
        }
    }

    private static enum ConnectionType {
        NORMAL,
        WIDENODE,
        LEFTLAYER,
        RIGHTLAYER;

    }
}

