/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.widenodesplitting;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.options.EdgeLabelPlacement;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.ArrayList;

public class LabelMerger {
    private LNode node;
    private ElkRectangle border;

    public LabelMerger(LNode node) {
        this.node = node;
    }

    public void mergeLabelsWithNode() {
        this.mergeNodeLabels();
        this.mergeEdgeLabels();
        this.updateNode();
    }

    public void resetNodeSizeAndPortPositionsIfLabelsIncluded() {
        if (this.includesMergedLabel()) {
            this.resetNodeSize();
            this.resetPortPositions();
        }
    }

    private void mergeNodeLabels() {
        this.border = new ElkRectangle(0.0, 0.0, this.node.getSize().x, this.node.getSize().y);
        ArrayList labelsToMerge = Lists.newArrayList(this.node.getLabels());
        for (LLabel label : labelsToMerge) {
            if (label.hasProperty(CoreOptions.NODE_LABELS_PLACEMENT) || this.node.hasProperty(CoreOptions.NODE_LABELS_PLACEMENT)) continue;
            this.mergeNodeLabel(label);
        }
    }

    private void mergeNodeLabel(LLabel label) {
        this.node.getLabels().remove(label);
        ElkRectangle labelBorder = new ElkRectangle(label.getPosition().x, label.getPosition().y, label.getSize().x, label.getSize().y);
        this.border.union(labelBorder);
    }

    private void mergeEdgeLabels() {
        this.mergeEastEdgeLabels();
        this.mergeWestEdgeLabels();
    }

    private void mergeEastEdgeLabels() {
        this.mergeEdgeLabelsAtSide(PortSide.EAST);
    }

    private void mergeWestEdgeLabels() {
        this.mergeEdgeLabelsAtSide(PortSide.WEST);
    }

    private void mergeEdgeLabelsAtSide(PortSide portSide) {
        for (LPort port : this.node.getPorts(portSide)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                this.mergeEdgeLabel(edge, EdgeLabelPlacement.TAIL, portSide);
            }
            for (LEdge edge : port.getIncomingEdges()) {
                this.mergeEdgeLabel(edge, EdgeLabelPlacement.HEAD, portSide);
            }
        }
    }

    private void mergeEdgeLabel(LEdge edge, EdgeLabelPlacement placement, PortSide portSide) {
        ArrayList labelsToRemove = Lists.newArrayList();
        for (LLabel label : edge.getLabels()) {
            if (!label.getProperty(CoreOptions.EDGE_LABELS_PLACEMENT).equals((Object)placement)) continue;
            this.mergeEdgeLabel(label, portSide);
            labelsToRemove.add(label);
            edge.getSource().setLabelWasRemovedByLabelMerger(true);
        }
        edge.getLabels().removeAll(labelsToRemove);
    }

    private void mergeEdgeLabel(LLabel label, PortSide portSide) {
        ElkRectangle labelBorder = this.getEdgeLabelBorder(label, portSide);
        this.border.union(labelBorder);
    }

    private ElkRectangle getEdgeLabelBorder(LLabel label, PortSide portSide) {
        double y = this.node.getSize().y;
        double x = portSide == PortSide.WEST ? -label.getSize().x : this.node.getSize().x;
        return new ElkRectangle(x, y, label.getSize().x, 0.0);
    }

    private void updateNode() {
        this.setLabelMarginForEachDirection();
        this.adjustNodeSize();
        this.setPortPositions(false);
    }

    private void setLabelMarginForEachDirection() {
        this.node.getLabelMargin().left = Math.abs(this.border.x);
        this.node.getLabelMargin().right = this.border.width - this.node.getSize().x - this.node.getLabelMargin().left;
        this.node.getLabelMargin().top = Math.abs(this.border.y);
        this.node.getLabelMargin().bottom = this.border.height - this.node.getSize().y - this.node.getLabelMargin().top;
    }

    private void adjustNodeSize() {
        this.node.getSize().x = this.border.width;
        this.node.getSize().y = this.border.height;
    }

    private void setPortPositions(boolean reset) {
        for (LPort port : this.node.getPorts()) {
            port.getPosition().x = this.getNewXPosition(port, reset);
            port.getPosition().y = this.getNewYPosition(port, reset);
        }
    }

    private double getNewXPosition(LPort port, boolean reset) {
        switch (port.getSide()) {
            case WEST: {
                return port.getPosition().x;
            }
            case EAST: {
                return !reset ? port.getPosition().x + this.node.getLabelMargin().left + this.node.getLabelMargin().right : port.getPosition().x - this.node.getLabelMargin().left - this.node.getLabelMargin().right;
            }
        }
        return !reset ? port.getPosition().x + this.node.getLabelMargin().left : port.getPosition().x - this.node.getLabelMargin().left;
    }

    private double getNewYPosition(LPort port, boolean reset) {
        switch (port.getSide()) {
            case NORTH: {
                return port.getPosition().y;
            }
            case SOUTH: {
                return !reset ? port.getPosition().y + this.node.getLabelMargin().top + this.node.getLabelMargin().bottom : port.getPosition().y - this.node.getLabelMargin().top - this.node.getLabelMargin().bottom;
            }
        }
        return !reset ? port.getPosition().y + this.node.getLabelMargin().top : port.getPosition().y - this.node.getLabelMargin().top;
    }

    private boolean includesMergedLabel() {
        return this.node.getLabelMargin().left > 0.0 || this.node.getLabelMargin().right > 0.0 || this.node.getLabelMargin().top > 0.0 || this.node.getLabelMargin().bottom > 0.0;
    }

    private void resetNodeSize() {
        this.node.getPosition().x += this.node.getLabelMargin().left;
        this.node.getSize().x = this.node.getSize().x - this.node.getLabelMargin().right - this.node.getLabelMargin().left;
        this.node.getPosition().y += this.node.getLabelMargin().top;
        this.node.getSize().y = this.node.getSize().y - this.node.getLabelMargin().bottom - this.node.getLabelMargin().top;
    }

    private void resetPortPositions() {
        this.setPortPositions(true);
    }
}

