/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.hyperedgedummymerger;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;

public final class HyperedgeDummyMergerForInteractiveMode
implements ILayoutProcessor<LGraph> {
    private LGraph graph;

    @Override
    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Hyperedge merging", 1.0f);
        this.graph = lGraph;
        this.mergeHyperEdges();
        monitor.done();
    }

    private void mergeHyperEdges() {
        this.mergeHyperEdges(true);
        this.mergeHyperEdges(false);
    }

    private void mergeHyperEdges(boolean forward) {
        this.graph.getLayers(forward).forEach(l -> this.mergeHyperEdges((Layer)l, forward));
    }

    private void mergeHyperEdges(Layer layer, boolean forward) {
        if (!layer.isEmpty()) {
            this.mergeHyperEdgesOfNonEmptyLayer(layer, forward);
        }
    }

    private void mergeHyperEdgesOfNonEmptyLayer(Layer layer, boolean forward) {
        LNode currNode = layer.getLastNode();
        while (currNode.hasUpperNeighbor()) {
            LNode upperNeighbor = currNode.getUpperNeighbor();
            this.mergeIfTheyShould(currNode, upperNeighbor, forward);
            currNode = upperNeighbor;
        }
    }

    private void mergeIfTheyShould(LNode mergeSource, LNode mergeTarget, boolean forward) {
        if (HyperedgeDummyMergerForInteractiveMode.shouldBeMerged(mergeSource, mergeTarget, forward)) {
            this.mergeNodes(mergeSource, mergeTarget);
        }
    }

    private static boolean shouldBeMerged(LNode a, LNode b, boolean forward) {
        return a.isLongEdge() && b.isLongEdge() && HyperedgeDummyMergerForInteractiveMode.getConnectedPort(a, !forward) == HyperedgeDummyMergerForInteractiveMode.getConnectedPort(b, !forward);
    }

    private static LPort getConnectedPort(LNode dummyNode, boolean forward) {
        return dummyNode.getEdges(forward).get(0).getPort(forward);
    }

    private void mergeNodes(LNode mergeSource, LNode mergeTarget) {
        this.mergeEdges(mergeSource, mergeTarget);
        this.updateLongEdgeProperties(mergeSource, mergeTarget);
        mergeSource.getLayer().getNodes().remove(mergeSource);
    }

    private void mergeEdges(LNode mergeSource, LNode mergeTarget) {
        mergeSource.getEdges().forEach(e -> this.redirectEdge((LEdge)e, mergeSource, mergeTarget));
    }

    private void redirectEdge(LEdge edge, LNode mergeSource, LNode mergeTarget) {
        if (edge.getTargetNode() == mergeSource) {
            LPort newTargetPort = mergeTarget.getPortsAsList(edge.getTargetSide()).get(0);
            edge.setTarget(newTargetPort);
        }
        if (edge.getSourceNode() == mergeSource) {
            LPort newSourcePort = mergeTarget.getPortsAsList(edge.getSourceSide()).get(0);
            edge.setSource(newSourcePort);
        }
    }

    private void updateLongEdgeProperties(LNode mergeSource, LNode mergeTarget) {
        HyperedgeDummyMergerForInteractiveMode.updateLongEdgeProperty(mergeSource, mergeTarget, InternalProperties.LONG_EDGE_SOURCE);
        HyperedgeDummyMergerForInteractiveMode.updateLongEdgeProperty(mergeSource, mergeTarget, InternalProperties.LONG_EDGE_TARGET);
    }

    private static void updateLongEdgeProperty(LNode mergeSource, LNode mergeTarget, IProperty<LPort> property) {
        if (mergeSource.getProperty(property) != mergeTarget.getProperty(property)) {
            mergeTarget.setProperty(property, (Object)null);
        }
    }
}

