/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight.HeightAdjustableNode;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.alg.layered.p4nodes.mes.MesNodePlacer;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;
import java.util.stream.Collectors;

public class NodeHeightAdjustmentProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Adjusting node heights", 1.0f);
        this.adjustNodeHeights(layeredGraph);
        progressMonitor.done();
    }

    private void adjustNodeHeights(LGraph layeredGraph) {
        List<HeightAdjustableNode> heightAdjustableNodes = this.getHeightAdjustableNodes(layeredGraph);
        this.adjustAccordingToConnectedLinearNodes(heightAdjustableNodes);
        this.furtherAdjustAccordingToAllConnectedNodes(heightAdjustableNodes);
    }

    private List<HeightAdjustableNode> getHeightAdjustableNodes(LGraph layeredGraph) {
        Spacings spacings = layeredGraph.getProperty(InternalProperties.SPACINGS);
        boolean newP4WillBeUsed = !MesNodePlacer.useOldVariant(layeredGraph);
        List<LNode> nodes = layeredGraph.getNodesFromAllLayers();
        return nodes.stream().map(node -> new HeightAdjustableNode((LNode)node, spacings, newP4WillBeUsed)).collect(Collectors.toList());
    }

    private void adjustAccordingToConnectedLinearNodes(List<HeightAdjustableNode> heightAdjustableNodes) {
        boolean onlyConsiderLinearNodes = true;
        this.adjust(heightAdjustableNodes, onlyConsiderLinearNodes);
    }

    private void furtherAdjustAccordingToAllConnectedNodes(List<HeightAdjustableNode> heightAdjustableNodes) {
        boolean onlyConsiderLinearNodes = false;
        this.adjust(heightAdjustableNodes, onlyConsiderLinearNodes);
    }

    private void adjust(List<HeightAdjustableNode> heightAdjustableNodes, boolean onlyConsiderLinearNodes) {
        heightAdjustableNodes.forEach(heightAdjustableNode -> heightAdjustableNode.adjust(onlyConsiderLinearNodes));
    }
}

