/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate.adjustnodeheight;

import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;

public class HeightForPortPair {
    private static final double MAX_ALLOWED_MULTIPE_OF_ORIG_PORT_SPACING = 2.0;
    private boolean onlyConsiderLinearNodes;
    private LPort upperPort;
    private LPort lowerPort;
    private Spacings spacings;
    private Integer originalHeight;
    private double originalPortSpacing;
    private double maxAllowedPortSpacing;
    private int numPortsOnSide;
    private double spacing;
    private LNode[] node;
    private LPort[] outPort;
    private LPort[] inPort;
    private LPort[] trueInPort;
    private int[] yShiftOfPort;
    private boolean heightIsDeterminedBySingleNode;
    private boolean newP4WillBeUsed;
    private double minimalNodeNodeSapcing;

    public HeightForPortPair(LPort upperPort, LPort lowerPort, int originalHeight, Spacings spacings, boolean newP4WillBeUsed) {
        this.upperPort = upperPort;
        this.lowerPort = lowerPort;
        this.originalHeight = originalHeight;
        this.spacings = spacings;
        this.newP4WillBeUsed = newP4WillBeUsed;
        this.originalPortSpacing = lowerPort.getPosition().y - upperPort.getPosition().y;
        this.maxAllowedPortSpacing = this.originalPortSpacing * 2.0;
        this.numPortsOnSide = upperPort.getNode().getTruePorts(upperPort.getSide()).size();
    }

    public void compute(boolean onlyConsiderLinNodes) {
        this.initialize(onlyConsiderLinNodes);
        while (this.followDataFlowToNextLayer()) {
            this.updateSpacingForCurrentLayer();
        }
    }

    public Integer getHeight() {
        if (this.spacing == this.originalPortSpacing) {
            return this.originalHeight;
        }
        if (this.spacing > this.originalPortSpacing && this.spacing <= this.maxAllowedPortSpacing) {
            Integer height = MesUtilMethods.roundUpToMultipleOfFive(this.spacing) * this.numPortsOnSide;
            return height;
        }
        return null;
    }

    public boolean heightIsDeterminedBySingleNode() {
        return this.heightIsDeterminedBySingleNode;
    }

    private void initialize(boolean onlyConsiderLinNodes) {
        this.onlyConsiderLinearNodes = onlyConsiderLinNodes;
        this.node = new LNode[2];
        this.node[0] = this.upperPort.getNode();
        this.node[1] = this.lowerPort.getNode();
        this.spacing = 0.0;
        this.outPort = new LPort[2];
        this.outPort[0] = this.upperPort;
        this.outPort[1] = this.lowerPort;
        this.inPort = new LPort[2];
        this.trueInPort = new LPort[2];
        this.yShiftOfPort = new int[2];
        this.heightIsDeterminedBySingleNode = false;
        this.minimalNodeNodeSapcing = this.node[0].getGraph().getProperty(LayeredOptions.SPACING_MIN_NODE_NODE_Y);
    }

    private boolean followDataFlowToNextLayer() {
        if (this.stopAtOutPorts()) {
            return false;
        }
        this.updateYShiftOfPortsWhenLeavingNode();
        this.updateInPorts();
        if (this.stopAtInPorts()) {
            return false;
        }
        int oldLayerIndexFirstNode = this.node[0].getLayer().getIndex();
        int oldLayerIndexSecondNode = this.node[1].getLayer().getIndex();
        this.updateNodes();
        if (this.onlyConsiderLinearNodes && this.nonLinearNodeReached()) {
            return false;
        }
        if (this.node[0] == this.node[1]) {
            this.treatSignalsEnteringSingleNode();
            return false;
        }
        if (this.node[0].getIndex() + 1 != this.node[1].getIndex()) {
            return false;
        }
        this.updateOutPorts();
        return this.isValidDataFlow(oldLayerIndexFirstNode, oldLayerIndexSecondNode);
    }

    private boolean stopAtOutPorts() {
        return this.stopAtOutPort(0) || this.stopAtOutPort(1);
    }

    private boolean stopAtOutPort(int ix) {
        return this.outPort[ix] == null || this.outPort[ix].getDegree() != 1;
    }

    private void updateYShiftOfPortsWhenLeavingNode() {
        this.updateYShiftOfPortWhenLeavingNode(0);
        this.updateYShiftOfPortWhenLeavingNode(1);
    }

    private void updateYShiftOfPortWhenLeavingNode(int ix) {
        if (!this.outPort[ix].isWideNodeInnerPort() && this.trueInPort[ix] != null) {
            int n = ix;
            this.yShiftOfPort[n] = (int)((double)this.yShiftOfPort[n] + (this.outPort[ix].getPosition().y - this.trueInPort[ix].getPosition().y));
        }
    }

    private void updateInPorts() {
        this.updateInPort(0);
        this.updateInPort(1);
    }

    private void updateInPort(int ix) {
        this.inPort[ix] = this.outPort[ix].getFirstConnectedPort();
        if (!this.inPort[ix].isWideNodeInnerPort()) {
            this.trueInPort[ix] = this.inPort[ix];
        }
    }

    private boolean stopAtInPorts() {
        return this.inPort[0].getDegree() > 1 || this.inPort[1].getDegree() > 1;
    }

    private boolean nonLinearNodeReached() {
        return this.trueConnectionsSplit(this.node[0]) || this.trueConnectionsSplit(this.node[1]);
    }

    public boolean trueConnectionsSplit(LNode reachedNode) {
        return reachedNode.getTrueIncomingEdges().size() > 1 || reachedNode.getTrueOutgoingEdges().size() > 1;
    }

    private void updateNodes() {
        this.node[0] = this.inPort[0].getNode();
        this.node[1] = this.inPort[1].getNode();
    }

    private void updateOutPorts() {
        this.outPort[0] = this.node[0].getLowestPortWithEdge(this.outPort[0].getSide());
        this.outPort[1] = this.node[1].getHighestPortWithEdge(this.outPort[1].getSide());
    }

    private boolean isValidDataFlow(int oldLayerIndexFirstNode, int oldLayerIndexSecondNode) {
        double diffLayerIndexFirstNode = this.node[0].getLayer().getIndex() - oldLayerIndexFirstNode;
        double diffLayerIndexSecondNode = this.node[1].getLayer().getIndex() - oldLayerIndexSecondNode;
        return diffLayerIndexFirstNode != 0.0 && diffLayerIndexSecondNode != 0.0;
    }

    private void treatSignalsEnteringSingleNode() {
        double portSpacingAtSingleNode;
        double spacingForCurrentLayer;
        if (!this.edgesToSingleNodeCross() && (spacingForCurrentLayer = (portSpacingAtSingleNode = this.node[0].getTruePortSpacing(this.inPort[0].getSide()).doubleValue()) + (double)this.yShiftOfPort[0] - (double)this.yShiftOfPort[1]) >= this.spacing) {
            this.spacing = spacingForCurrentLayer;
            this.heightIsDeterminedBySingleNode = true;
        }
    }

    private boolean edgesToSingleNodeCross() {
        return this.inPort[0].getPosition().y > this.inPort[1].getPosition().y;
    }

    private void updateSpacingForCurrentLayer() {
        double nodeNodeSpacing = this.onlyConsiderLinearNodes && this.newP4WillBeUsed ? this.minimalNodeNodeSapcing : this.spacings.getVerticalSpacing(this.node[0], this.node[1]);
        double spacingForCurrentLayer = this.node[0].getSize().y - this.trueInPort[0].getPosition().y + nodeNodeSpacing + this.trueInPort[1].getPosition().y + (double)this.yShiftOfPort[0] - (double)this.yShiftOfPort[1];
        this.spacing = Math.max(this.spacing, spacingForCurrentLayer);
    }
}

