/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopHolder;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.routing.AbstractSelfLoopRouter;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.routing.LabelPlacer;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.routing.OrthogonalSelfLoopRouter;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.routing.RoutingDirector;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.routing.RoutingSlotAssigner;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.labels.ILabelManager;
import com.modelengineers.MoRe_elk.core.labels.LabelManagementOptions;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public class SelfLoopRouter
implements ILayoutProcessor<LGraph> {
    private final RoutingDirector routingDirector = new RoutingDirector();
    private final LabelPlacer labelPlacer = new LabelPlacer();
    private final RoutingSlotAssigner routingSlotAssigner = new RoutingSlotAssigner();

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop routing", 1.0f);
        OrthogonalSelfLoopRouter router = new OrthogonalSelfLoopRouter();
        ILabelManager labelManager = graph.getProperty(LabelManagementOptions.LABEL_MANAGER);
        graph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(lNode -> lNode.getType() == LNode.NodeType.NORMAL).filter(lNode -> lNode.hasProperty(InternalProperties.SELF_LOOP_HOLDER)).map(lNode -> lNode.getProperty(InternalProperties.SELF_LOOP_HOLDER)).forEach(slHolder -> this.processNode((SelfLoopHolder)slHolder, labelManager, router, progressMonitor));
        progressMonitor.done();
    }

    private void processNode(SelfLoopHolder slHolder, ILabelManager labelManager, AbstractSelfLoopRouter slRouter, IElkProgressMonitor monitor) {
        this.routingDirector.determineLoopRoutes(slHolder);
        this.labelPlacer.placeLabels(slHolder, labelManager, monitor);
        this.routingSlotAssigner.assignRoutingSlots(slHolder);
        slRouter.routeSelfLoops(slHolder);
    }
}

