/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopHolder;
import com.modelengineers.MoRe_elk.alg.layered.intermediate.loops.SelfLoopPort;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public class SelfLoopPreProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop pre-processing", 1.0f);
        for (LNode lnode : graph.getLayerlessNodes()) {
            if (!SelfLoopHolder.needsSelfLoopProcessing(lnode)) continue;
            SelfLoopHolder slHolder = SelfLoopHolder.install(lnode);
            this.hideSelfLoops(slHolder);
            this.hidePorts(slHolder);
        }
        progressMonitor.done();
    }

    private void hideSelfLoops(SelfLoopHolder slHolder) {
        slHolder.getSLHyperLoops().stream().flatMap(slLoop -> slLoop.getSLEdges().stream()).map(slEdge -> slEdge.getLEdge()).forEach(lEdge -> this.hideSelfLoop((LEdge)lEdge));
    }

    private void hideSelfLoop(LEdge lEdge) {
        lEdge.setSource(null);
        lEdge.setTarget(null);
    }

    private void hidePorts(SelfLoopHolder slHolder) {
        boolean hierarchyMode;
        LNode lNode = slHolder.getLNode();
        LGraph nestedGraph = lNode.getNestedGraph();
        boolean orderFixed = lNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isOrderFixed();
        boolean bl = hierarchyMode = nestedGraph != null && nestedGraph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS);
        if (orderFixed || hierarchyMode) {
            return;
        }
        for (SelfLoopPort slPort : slHolder.getSLPortMap().values()) {
            if (!slPort.hadOnlySelfLoops()) continue;
            LPort lPort = slPort.getLPort();
            lPort.setNode(null);
            slPort.setHidden(true);
            slHolder.setPortsHidden(true);
            assert (lPort.getProperty(InternalProperties.PORT_DUMMY) == null);
        }
    }
}

