/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.stream.Stream;

public final class ReversedEdgeRestorer
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Restoring reversed edges", 1.0f);
        this.process(layeredGraph);
        assert (this.noReversedEdgesRemaining(layeredGraph));
        monitor.done();
    }

    private void process(LGraph layeredGraph) {
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edgeArray;
                    LEdge[] lEdgeArray = edgeArray = LGraphUtil.toEdgeArray(port.getOutgoingEdges());
                    int n = edgeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (edge.getProperty(InternalProperties.REVERSED).booleanValue()) {
                            edge.reverse(layeredGraph, false);
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    public boolean noReversedEdgesRemaining(LGraph layeredGraph) {
        Stream edges = layeredGraph.getNodesFromAllLayers().stream().flatMap(n -> n.getOutgoingEdgesAsList().stream());
        return edges.noneMatch(edge -> edge.getProperty(InternalProperties.REVERSED));
    }
}

