/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.List;
import java.util.stream.Collectors;

public final class MesBackEdgeReverser
implements ILayoutProcessor<LGraph> {
    private List<LEdge> backEdges;

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Reversing back edges", 1.0f);
        this.detectBackEdges(graph);
        this.reverseBackEdges(graph);
        assert (this.noBackEdgesInGraph(graph));
        monitor.done();
    }

    private void detectBackEdges(LGraph graph) {
        this.backEdges = graph.getLayers().stream().flatMap(l -> l.getNodes().stream().flatMap(n -> n.getOutgoingEdgesAsList().stream())).filter(edge -> MesBackEdgeReverser.isBackEdge(edge)).collect(Collectors.toList());
    }

    private static boolean isBackEdge(LEdge edge) {
        Layer sourceLayer = edge.getSourceNode().getLayer();
        Layer targetLayer = edge.getTargetNode().getLayer();
        return targetLayer.getIndex() < sourceLayer.getIndex();
    }

    private void reverseBackEdges(LGraph graph) {
        if (!this.backEdges.isEmpty()) {
            graph.setProperty(InternalProperties.CYCLIC, (Object)true);
            this.backEdges.forEach(edge -> edge.reverse(graph, false));
        }
    }

    private boolean noBackEdgesInGraph(LGraph graph) {
        return graph.getLayers().stream().flatMap(l -> l.getNodes().stream().flatMap(n -> n.getOutgoingEdgesAsList().stream())).noneMatch(e -> MesBackEdgeReverser.isBackEdge(e));
    }
}

