/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;

public final class LayerSizeAndGraphHeightCalculator
implements ILayoutProcessor<LGraph> {
    private static final double TOLERANCE = 0.1;

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer size calculation", 1.0f);
        this.process(layeredGraph);
        assert (this.allNodesContainedInGraphHeight(layeredGraph));
        monitor.done();
    }

    private void process(LGraph layeredGraph) {
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        boolean foundNodes = false;
        for (Layer layer : layeredGraph) {
            KVector layerSize = layer.getSize();
            layerSize.x = 0.0;
            layerSize.y = 0.0;
            if (layer.getNodes().isEmpty()) continue;
            foundNodes = true;
            for (LNode node : layer) {
                KVector nodeSize = node.getSize();
                LMargin nodeMargin = node.getMargin();
                layerSize.x = Math.max(layerSize.x, nodeSize.x + nodeMargin.left + nodeMargin.right);
            }
            LNode firstNode = layer.getNodes().get(0);
            double top = firstNode.getPosition().y - firstNode.getMargin().top;
            if (firstNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
                top -= layeredGraph.getProperty(LayeredOptions.SPACING_PORTS_SURROUNDING).getTop();
            }
            LNode lastNode = layer.getNodes().get(layer.getNodes().size() - 1);
            double bottom = lastNode.getPosition().y + lastNode.getSize().y + lastNode.getMargin().bottom;
            if (lastNode.getType() == LNode.NodeType.EXTERNAL_PORT) {
                bottom += layeredGraph.getProperty(LayeredOptions.SPACING_PORTS_SURROUNDING).getBottom();
            }
            layerSize.y = bottom - top;
            minY = Math.min(minY, top);
            maxY = Math.max(maxY, bottom);
        }
        if (!foundNodes) {
            minY = 0.0;
            maxY = 0.0;
        }
        layeredGraph.getSize().y = maxY - minY;
        layeredGraph.getOffset().y -= minY;
    }

    private boolean allNodesContainedInGraphHeight(LGraph layeredGraph) {
        double top = 0.0 - layeredGraph.getOffset().y;
        double bottom = layeredGraph.getSize().y - layeredGraph.getOffset().y;
        return layeredGraph.getNodesFromAllLayers().stream().allMatch(node -> {
            double nodeTop = node.getPosition().y - node.getMargin().top;
            double nodeBottom = node.getPosition().y + node.getSize().y + node.getMargin().bottom;
            return (nodeTop > top || Math.abs(nodeTop - top) < 0.1) && (nodeBottom < bottom || Math.abs(nodeBottom - bottom) < 0.1);
        });
    }
}

