/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.NodeDimensionCalculation;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphAdapters;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.GraphProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.PortLabelPlacement;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Set;

public final class LabelAndNodeSizeProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Node and Port Label Placement and Node Sizing", 1.0f);
        NodeDimensionCalculation.calculateLabelAndNodeSizes(LGraphAdapters.adapt(layeredGraph, true, true, node -> node.getType() == LNode.NodeType.NORMAL || node.getType() == LNode.NodeType.WIDE_NODE));
        if (layeredGraph.getProperty(InternalProperties.GRAPH_PROPERTIES).contains((Object)GraphProperties.EXTERNAL_PORTS)) {
            Set portLabelPlacement = layeredGraph.getProperty(LayeredOptions.PORT_LABELS_PLACEMENT);
            boolean placeNextToPort = portLabelPlacement.contains((Object)PortLabelPlacement.NEXT_TO_PORT_IF_POSSIBLE);
            boolean treatAsGroup = layeredGraph.getProperty(LayeredOptions.PORT_LABELS_TREAT_AS_GROUP);
            for (Layer layer : layeredGraph.getLayers()) {
                layer.getNodes().stream().filter(node -> node.getType() == LNode.NodeType.EXTERNAL_PORT).forEach(dummy -> this.placeExternalPortDummyLabels((LNode)dummy, portLabelPlacement, placeNextToPort, treatAsGroup));
            }
        }
        monitor.done();
    }

    private void placeExternalPortDummyLabels(LNode dummy, Set<PortLabelPlacement> graphPortLabelPlacement, boolean placeNextToPortIfPossible, boolean treatAsGroup) {
        double labelHeight;
        double labelPortSpacingHorizontal = dummy.getProperty(LayeredOptions.SPACING_LABEL_PORT_HORIZONTAL);
        double labelPortSpacingVertical = dummy.getProperty(LayeredOptions.SPACING_LABEL_PORT_VERTICAL);
        double labelLabelSpacing = dummy.getProperty(LayeredOptions.SPACING_LABEL_LABEL);
        KVector dummySize = dummy.getSize();
        LPort dummyPort = dummy.getPorts().get(0);
        KVector dummyPortPos = dummyPort.getPosition();
        ElkRectangle portLabelBox = this.computePortLabelBox(dummyPort, labelLabelSpacing);
        if (portLabelBox == null) {
            return;
        }
        if (graphPortLabelPlacement.contains((Object)PortLabelPlacement.INSIDE)) {
            switch (dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: {
                    portLabelBox.x = (dummySize.x - portLabelBox.width) / 2.0 - dummyPortPos.x;
                    portLabelBox.y = labelPortSpacingVertical;
                    break;
                }
                case SOUTH: {
                    portLabelBox.x = (dummySize.x - portLabelBox.width) / 2.0 - dummyPortPos.x;
                    portLabelBox.y = -labelPortSpacingVertical - portLabelBox.height;
                    break;
                }
                case EAST: {
                    if (this.labelNextToPort(dummyPort, true, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                    } else {
                        portLabelBox.y = dummySize.y + labelPortSpacingVertical - dummyPortPos.y;
                    }
                    portLabelBox.x = -labelPortSpacingHorizontal - portLabelBox.width;
                    break;
                }
                case WEST: {
                    if (this.labelNextToPort(dummyPort, true, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                    } else {
                        portLabelBox.y = dummySize.y + labelPortSpacingVertical - dummyPortPos.y;
                    }
                    portLabelBox.x = labelPortSpacingHorizontal;
                }
            }
        } else if (graphPortLabelPlacement.contains((Object)PortLabelPlacement.OUTSIDE)) {
            switch (dummy.getProperty(InternalProperties.EXT_PORT_SIDE)) {
                case NORTH: 
                case SOUTH: {
                    portLabelBox.x = dummyPortPos.x + labelPortSpacingHorizontal;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (this.labelNextToPort(dummyPort, false, placeNextToPortIfPossible)) {
                        labelHeight = treatAsGroup ? portLabelBox.height : dummyPort.getLabels().get((int)0).getSize().y;
                        portLabelBox.y = (dummySize.y - labelHeight) / 2.0 - dummyPortPos.y;
                        break;
                    }
                    portLabelBox.y = dummyPortPos.y + labelPortSpacingVertical;
                }
            }
        }
        double currentY = portLabelBox.y;
        for (LLabel label : dummyPort.getLabels()) {
            KVector labelPos = label.getPosition();
            labelPos.x = portLabelBox.x;
            labelPos.y = currentY;
            currentY += label.getSize().y + labelLabelSpacing;
        }
    }

    private ElkRectangle computePortLabelBox(LPort dummyPort, double labelLabelSpacing) {
        if (dummyPort.getLabels().isEmpty()) {
            return null;
        }
        ElkRectangle result = new ElkRectangle();
        for (LLabel label : dummyPort.getLabels()) {
            KVector labelSize = label.getSize();
            result.width = Math.max(result.width, labelSize.x);
            result.height += labelSize.y;
        }
        result.height += (double)(dummyPort.getLabels().size() - 1) * labelLabelSpacing;
        return result;
    }

    private boolean labelNextToPort(LPort dummyPort, boolean insideLabels, boolean placeNextToPortIfPossible) {
        if (!placeNextToPortIfPossible) {
            return false;
        }
        if (insideLabels) {
            return dummyPort.getIncomingEdges().isEmpty() && dummyPort.getOutgoingEdges().isEmpty();
        }
        return !dummyPort.isConnectedToExternalNodes();
    }
}

