/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.LabelCell;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.Map;

public final class EndLabelPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("End label post-processing", 1.0f);
        layeredGraph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(node -> node.getType() == LNode.NodeType.NORMAL && node.hasProperty(InternalProperties.END_LABELS)).forEach(node -> this.processNode((LNode)node));
        monitor.done();
    }

    private void processNode(LNode node) {
        assert (node.hasProperty(InternalProperties.END_LABELS));
        Map<LPort, LabelCell> endLabelCells = node.getProperty(InternalProperties.END_LABELS);
        assert (!endLabelCells.isEmpty());
        KVector nodePos = node.getPosition();
        for (LabelCell labelCell : endLabelCells.values()) {
            ElkRectangle labelCellRect = labelCell.getCellRectangle();
            labelCellRect.move(nodePos);
            labelCell.applyLabelLayout();
        }
        node.setProperty(InternalProperties.END_LABELS, (Object)null);
    }
}

