/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphUtil;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.PortConstraints;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;

public final class DummySelfLoopProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Self-loop processing", 1.0f);
        ArrayList createdDummies = Lists.newArrayList();
        for (Layer layer : layeredGraph) {
            createdDummies.clear();
            for (LNode node : layer) {
                for (LPort port : node.getPorts()) {
                    LEdge[] edges;
                    LEdge[] lEdgeArray = edges = LGraphUtil.toEdgeArray(port.getOutgoingEdges());
                    int n = edges.length;
                    int n2 = 0;
                    while (n2 < n) {
                        LEdge edge = lEdgeArray[n2];
                        if (edge.getSource().getNode() == edge.getTarget().getNode()) {
                            LPort sourcePort = edge.getSource();
                            LPort targetPort = edge.getTarget();
                            PortSide sourcePortSide = sourcePort.getSide();
                            PortSide targetPortSide = targetPort.getSide();
                            if ((sourcePortSide == PortSide.NORTH || sourcePortSide == PortSide.SOUTH) && targetPortSide == PortSide.WEST) {
                                edge.reverse(layeredGraph, false);
                            } else if (sourcePortSide == PortSide.SOUTH && targetPortSide == PortSide.NORTH) {
                                edge.reverse(layeredGraph, false);
                            } else if (sourcePortSide == PortSide.EAST && targetPortSide != PortSide.EAST) {
                                edge.reverse(layeredGraph, false);
                            }
                            if (sourcePortSide == PortSide.EAST && targetPortSide == PortSide.WEST) {
                                createdDummies.add(this.createDummy(layeredGraph, edge, targetPort, sourcePort));
                            } else if (sourcePortSide == PortSide.WEST && targetPortSide == PortSide.EAST) {
                                createdDummies.add(this.createDummy(layeredGraph, edge, sourcePort, targetPort));
                            }
                        }
                        ++n2;
                    }
                }
            }
            for (LNode dummy : createdDummies) {
                dummy.setLayer(layer);
            }
        }
        monitor.done();
    }

    private LNode createDummy(LGraph layeredGraph, LEdge edge, LPort sourcePort, LPort targetPort) {
        LNode dummyNode = new LNode(layeredGraph);
        dummyNode.setType(LNode.NodeType.LONG_EDGE);
        dummyNode.setProperty(InternalProperties.ORIGIN, edge);
        dummyNode.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        dummyNode.setProperty(InternalProperties.LONG_EDGE_SOURCE, sourcePort);
        dummyNode.setProperty(InternalProperties.LONG_EDGE_TARGET, targetPort);
        LPort dummyInput = new LPort();
        dummyInput.setSide(PortSide.WEST);
        dummyInput.setNode(dummyNode);
        LPort dummyOutput = new LPort();
        dummyOutput.setSide(PortSide.EAST);
        dummyOutput.setNode(dummyNode);
        edge.setTarget(dummyInput);
        LEdge dummyEdge = new LEdge();
        dummyEdge.copyProperties(edge);
        dummyEdge.setProperty(LayeredOptions.JUNCTION_POINTS, (Object)null);
        dummyEdge.setSource(dummyOutput);
        dummyEdge.setTarget(targetPort);
        return dummyNode;
    }
}

