/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CommentPreprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Comment pre-processing", 1.0f);
        int commentBoxCount = 0;
        Iterator<LNode> nodeIter = layeredGraph.getLayerlessNodes().iterator();
        while (nodeIter.hasNext()) {
            LNode node = nodeIter.next();
            if (!node.getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) continue;
            ++commentBoxCount;
            int edgeCount = 0;
            LEdge edge = null;
            LPort oppositePort = null;
            for (LPort port : node.getPorts()) {
                edgeCount += port.getDegree();
                if (port.getIncomingEdges().size() == 1) {
                    edge = port.getIncomingEdges().get(0);
                    oppositePort = edge.getSource();
                }
                if (port.getOutgoingEdges().size() != 1) continue;
                edge = port.getOutgoingEdges().get(0);
                oppositePort = edge.getTarget();
            }
            if (edgeCount == 1 && oppositePort.getDegree() == 1 && !oppositePort.getNode().getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) {
                this.processBox(node, edge, oppositePort, oppositePort.getNode());
                nodeIter.remove();
                continue;
            }
            ArrayList revEdges = Lists.newArrayList();
            for (LPort port : node.getPorts()) {
                for (LEdge outedge : port.getOutgoingEdges()) {
                    if (outedge.getTarget().getOutgoingEdges().isEmpty()) continue;
                    revEdges.add(outedge);
                }
                for (LEdge inedge : port.getIncomingEdges()) {
                    if (inedge.getSource().getIncomingEdges().isEmpty()) continue;
                    revEdges.add(inedge);
                }
            }
            for (LEdge re : revEdges) {
                re.reverse(layeredGraph, true);
            }
        }
        if (monitor.isLoggingEnabled()) {
            monitor.log("Found " + commentBoxCount + " comment boxes");
        }
        monitor.done();
    }

    private void processBox(LNode box, LEdge edge, LPort oppositePort, LNode realNode) {
        List<Object> boxList;
        boolean topFirst;
        boolean onlyTop = false;
        boolean onlyBottom = false;
        if (realNode.getProperty(LayeredOptions.PORT_CONSTRAINTS).isSideFixed()) {
            boolean hasNorth = false;
            boolean hasSouth = false;
            block0: for (LPort port1 : realNode.getPorts()) {
                for (LPort port2 : port1.getConnectedPorts()) {
                    if (port2.getNode().getProperty(LayeredOptions.COMMENT_BOX).booleanValue()) continue;
                    if (port1.getSide() == PortSide.NORTH) {
                        hasNorth = true;
                        break block0;
                    }
                    if (port1.getSide() != PortSide.SOUTH) continue;
                    hasSouth = true;
                    break block0;
                }
            }
            onlyTop = hasSouth && !hasNorth;
            boolean bl = onlyBottom = hasNorth && !hasSouth;
        }
        if (!(onlyTop || onlyBottom || realNode.getLabels().isEmpty())) {
            double labelPos = 0.0;
            for (LLabel label : realNode.getLabels()) {
                labelPos += label.getPosition().y + label.getSize().y / 2.0;
            }
            topFirst = (labelPos /= (double)realNode.getLabels().size()) >= realNode.getSize().y / 2.0;
        } else {
            boolean bl = topFirst = !onlyBottom;
        }
        if (topFirst) {
            List<LNode> topBoxes = realNode.getProperty(InternalProperties.TOP_COMMENTS);
            if (topBoxes == null) {
                boxList = Lists.newArrayList();
                realNode.setProperty(InternalProperties.TOP_COMMENTS, boxList);
            } else if (onlyTop) {
                boxList = topBoxes;
            } else {
                List<LNode> bottomBoxes = realNode.getProperty(InternalProperties.BOTTOM_COMMENTS);
                if (bottomBoxes == null) {
                    boxList = Lists.newArrayList();
                    realNode.setProperty(InternalProperties.BOTTOM_COMMENTS, boxList);
                } else {
                    boxList = topBoxes.size() <= bottomBoxes.size() ? topBoxes : bottomBoxes;
                }
            }
        } else {
            List<LNode> bottomBoxes = realNode.getProperty(InternalProperties.BOTTOM_COMMENTS);
            if (bottomBoxes == null) {
                boxList = Lists.newArrayList();
                realNode.setProperty(InternalProperties.BOTTOM_COMMENTS, boxList);
            } else if (onlyBottom) {
                boxList = bottomBoxes;
            } else {
                List<LNode> topBoxes = realNode.getProperty(InternalProperties.TOP_COMMENTS);
                if (topBoxes == null) {
                    boxList = Lists.newArrayList();
                    realNode.setProperty(InternalProperties.TOP_COMMENTS, boxList);
                } else {
                    boxList = bottomBoxes.size() <= topBoxes.size() ? bottomBoxes : topBoxes;
                }
            }
        }
        boxList.add(box);
        box.setProperty(InternalProperties.COMMENT_CONN_PORT, oppositePort);
        if (edge.getTarget() == oppositePort) {
            edge.setTarget(null);
            if (oppositePort.getDegree() == 0) {
                oppositePort.setNode(null);
            }
            this.removeHierarchicalPortDummyNode(oppositePort);
        } else {
            edge.setSource(null);
            if (oppositePort.getDegree() == 0) {
                oppositePort.setNode(null);
            }
        }
        edge.getBendPoints().clear();
    }

    private void removeHierarchicalPortDummyNode(LPort oppositePort) {
        LNode dummy = oppositePort.getProperty(InternalProperties.PORT_DUMMY);
        if (dummy != null) {
            Layer layer = dummy.getLayer();
            layer.getNodes().remove(dummy);
            if (layer.getNodes().isEmpty()) {
                dummy.getGraph().getLayers().remove(layer);
            }
        }
    }
}

