/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.intermediate;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.Spacings;
import com.modelengineers.MoRe_elk.core.alg.ILayoutProcessor;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.util.IElkProgressMonitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class CommentPostprocessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Comment post-processing", 1.0f);
        for (Layer layer : layeredGraph) {
            ArrayList boxes = Lists.newArrayList();
            for (LNode node : layer) {
                List<LNode> topBoxes = node.getProperty(InternalProperties.TOP_COMMENTS);
                List<LNode> bottomBoxes = node.getProperty(InternalProperties.BOTTOM_COMMENTS);
                if (topBoxes == null && bottomBoxes == null) continue;
                this.process(node, topBoxes, bottomBoxes);
                if (topBoxes != null) {
                    boxes.addAll(topBoxes);
                }
                if (bottomBoxes == null) continue;
                boxes.addAll(bottomBoxes);
            }
            layer.getNodes().addAll(boxes);
        }
        monitor.done();
    }

    private void process(LNode node, List<LNode> topBoxes, List<LNode> bottomBoxes) {
        LPort nodePort;
        LPort boxPort;
        double anchorX;
        double anchorInc;
        double baseLine;
        double maxHeight;
        double boxesWidth;
        KVector nodePos = node.getPosition();
        KVector nodeSize = node.getSize();
        LMargin margin = node.getMargin();
        double commentCommentSpacing = Spacings.getIndividualOrDefault(node, LayeredOptions.SPACING_COMMENT_COMMENT);
        if (topBoxes != null) {
            boxesWidth = commentCommentSpacing * (double)(topBoxes.size() - 1);
            maxHeight = 0.0;
            for (LNode box : topBoxes) {
                boxesWidth += box.getSize().x;
                maxHeight = Math.max(maxHeight, box.getSize().y);
            }
            double x = nodePos.x - (boxesWidth - nodeSize.x) / 2.0;
            baseLine = nodePos.y - margin.top + maxHeight;
            anchorX = anchorInc = nodeSize.x / (double)(topBoxes.size() + 1);
            for (LNode box : topBoxes) {
                box.getPosition().x = x;
                box.getPosition().y = baseLine - box.getSize().y;
                x += box.getSize().x + commentCommentSpacing;
                boxPort = this.getBoxPort(box);
                boxPort.getPosition().x = box.getSize().x / 2.0 - boxPort.getAnchor().x;
                boxPort.getPosition().y = box.getSize().y;
                nodePort = box.getProperty(InternalProperties.COMMENT_CONN_PORT);
                if (nodePort.getDegree() == 1) {
                    nodePort.getPosition().x = anchorX - nodePort.getAnchor().x;
                    nodePort.getPosition().y = 0.0;
                    nodePort.setNode(node);
                }
                anchorX += anchorInc;
            }
        }
        if (bottomBoxes != null) {
            boxesWidth = commentCommentSpacing * (double)(bottomBoxes.size() - 1);
            maxHeight = 0.0;
            for (LNode box : bottomBoxes) {
                boxesWidth += box.getSize().x;
                maxHeight = Math.max(maxHeight, box.getSize().y);
            }
            double x = nodePos.x - (boxesWidth - nodeSize.x) / 2.0;
            baseLine = nodePos.y + nodeSize.y + margin.bottom - maxHeight;
            anchorX = anchorInc = nodeSize.x / (double)(bottomBoxes.size() + 1);
            for (LNode box : bottomBoxes) {
                box.getPosition().x = x;
                box.getPosition().y = baseLine;
                x += box.getSize().x + commentCommentSpacing;
                boxPort = this.getBoxPort(box);
                boxPort.getPosition().x = box.getSize().x / 2.0 - boxPort.getAnchor().x;
                boxPort.getPosition().y = 0.0;
                nodePort = box.getProperty(InternalProperties.COMMENT_CONN_PORT);
                if (nodePort.getDegree() == 1) {
                    nodePort.getPosition().x = anchorX - nodePort.getAnchor().x;
                    nodePort.getPosition().y = nodeSize.y;
                    nodePort.setNode(node);
                }
                anchorX += anchorInc;
            }
        }
    }

    private LPort getBoxPort(LNode commentBox) {
        LPort nodePort = commentBox.getProperty(InternalProperties.COMMENT_CONN_PORT);
        for (LPort port : commentBox.getPorts()) {
            Iterator<LEdge> iterator = port.getOutgoingEdges().iterator();
            if (iterator.hasNext()) {
                LEdge edge = iterator.next();
                edge.setTarget(nodePort);
                return port;
            }
            iterator = port.getIncomingEdges().iterator();
            if (!iterator.hasNext()) continue;
            LEdge edge = iterator.next();
            edge.setSource(nodePort);
            return port;
        }
        return null;
    }
}

