/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph.transform;

import com.google.common.base.Strings;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.transform.ElkGraphImporter;
import com.modelengineers.MoRe_elk.alg.layered.graph.transform.ElkGraphLayoutTransferrer;
import com.modelengineers.MoRe_elk.alg.layered.graph.transform.IGraphTransformer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_emf.ecore.EObject;

public class ElkGraphTransformer
implements IGraphTransformer<ElkNode> {
    @Override
    public LGraph importGraph(ElkNode graph) {
        return new ElkGraphImporter().importGraph(graph);
    }

    @Override
    public void applyLayout(LGraph layeredGraph) {
        new ElkGraphLayoutTransferrer().applyLayout(layeredGraph);
    }

    public static String getOriginIdentifier(LGraphElement element) {
        Object origin = element.getProperty(InternalProperties.ORIGIN);
        if (origin instanceof ElkGraphElement) {
            return ElkGraphTransformer.getIdentifier((ElkGraphElement)origin);
        }
        return null;
    }

    private static String getIdentifier(ElkGraphElement element) {
        String id = element.getIdentifier();
        if (!Strings.isNullOrEmpty((String)id)) {
            String parentId;
            EObject container = element.eContainer();
            if (container instanceof ElkGraphElement && (parentId = ElkGraphTransformer.getIdentifier((ElkGraphElement)container)) != null) {
                return String.valueOf(parentId) + '.' + id;
            }
            return id;
        }
        return null;
    }
}

