/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LShape;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.mesutils.MesUtilMethods;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.PortType;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class LPort
extends LShape {
    private static final long serialVersionUID = -3406558719744943360L;
    public static final Predicate<LPort> OUTPUT_PREDICATE = port -> !port.outgoingEdges.isEmpty();
    public static final Predicate<LPort> INPUT_PREDICATE = port -> !port.incomingEdges.isEmpty();
    public static final Predicate<LPort> NORTH_PREDICATE = port -> port.side == PortSide.NORTH;
    public static final Predicate<LPort> EAST_PREDICATE = port -> port.side == PortSide.EAST;
    public static final Predicate<LPort> SOUTH_PREDICATE = port -> port.side == PortSide.SOUTH;
    public static final Predicate<LPort> WEST_PREDICATE = port -> port.side == PortSide.WEST;
    private LNode owner;
    private PortSide side = PortSide.UNDEFINED;
    private final KVector anchor = new KVector();
    private boolean explicitlySuppliedPortAnchor = false;
    private final LMargin margin = new LMargin();
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)2);
    private final List<LEdge> incomingEdges = Lists.newArrayListWithCapacity((int)4);
    private final List<LEdge> outgoingEdges = Lists.newArrayListWithCapacity((int)4);
    private Iterable<LEdge> connectedEdges = new CombineIter<LEdge>(this.incomingEdges, this.outgoingEdges);
    private Boolean wideNodeInnerPort = null;
    private boolean connectedToExternalNodes = true;
    private boolean labelWasRemovedByLabelMerger = false;

    public LNode getNode() {
        return this.owner;
    }

    public void setNode(LNode node) {
        if (this.owner != null) {
            this.owner.getPorts().remove(this);
        }
        this.owner = node;
        if (this.owner != null) {
            this.owner.getPorts().add(this);
        }
    }

    public boolean isOnSameNodeAs(LPort port) {
        return this.getNode() == port.getNode();
    }

    public boolean isOnSameTrueNodeAs(LPort port) {
        return this.getNode().getTrueNode().equals(port.getNode().getTrueNode());
    }

    public PortSide getSide() {
        return this.side;
    }

    public void setSide(PortSide theside) {
        if (theside == null) {
            throw new NullPointerException();
        }
        this.side = theside;
        if (!this.isExplicitlySuppliedPortAnchor()) {
            switch (this.side) {
                case NORTH: {
                    this.getAnchor().x = this.getSize().x / 2.0;
                    this.getAnchor().y = 0.0;
                    break;
                }
                case EAST: {
                    this.getAnchor().x = this.getSize().x;
                    this.getAnchor().y = this.getSize().y / 2.0;
                    break;
                }
                case SOUTH: {
                    this.getAnchor().x = this.getSize().x / 2.0;
                    this.getAnchor().y = this.getSize().y;
                    break;
                }
                case WEST: {
                    this.getAnchor().x = 0.0;
                    this.getAnchor().y = this.getSize().y / 2.0;
                }
            }
        }
    }

    public boolean isOnSide(PortSide sideToCheck) {
        return sideToCheck.equals((Object)this.side);
    }

    public boolean isOnSameSideAs(LPort port) {
        assert (this.getSide() != PortSide.UNDEFINED);
        return this.getSide() == port.getSide();
    }

    public boolean isOnlyPortOnSide() {
        return this.getNode().getPortsAsList(this.getSide()).size() == 1;
    }

    public KVector getAnchor() {
        return this.anchor;
    }

    public boolean isExplicitlySuppliedPortAnchor() {
        return this.explicitlySuppliedPortAnchor;
    }

    public void setExplicitlySuppliedPortAnchor(boolean fixed) {
        this.explicitlySuppliedPortAnchor = fixed;
    }

    public KVector getAbsoluteAnchor() {
        return KVector.sum(this.owner.getPosition(), this.getPosition(), this.anchor);
    }

    public LMargin getMargin() {
        return this.margin;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public String getName() {
        if (!this.labels.isEmpty()) {
            return this.labels.get(0).getText();
        }
        return null;
    }

    public boolean isWideNodeInnerPort() {
        if (this.wideNodeInnerPort == null) {
            this.wideNodeInnerPort = this.getProperty(InternalProperties.WIDE_NODE_INNER_PORT);
        }
        return this.wideNodeInnerPort;
    }

    public boolean isNorthOrSouthPort() {
        return PortSide.isNorthSouth(this.side);
    }

    public int getDegree() {
        return this.incomingEdges.size() + this.outgoingEdges.size();
    }

    public int getNetFlow() {
        return this.incomingEdges.size() - this.outgoingEdges.size();
    }

    public List<LEdge> getEdges(boolean forward) {
        return forward ? this.getOutgoingEdges() : this.getIncomingEdges();
    }

    public List<LEdge> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<LEdge> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    public boolean hasEdges() {
        return this.hasIncomingEdges() || this.hasOutgoingEdges();
    }

    public boolean hasIncomingEdges() {
        return !this.incomingEdges.isEmpty();
    }

    public boolean hasOutgoingEdges() {
        return !this.outgoingEdges.isEmpty();
    }

    public boolean hasEdges(boolean forward) {
        return forward ? this.hasOutgoingEdges() : this.hasIncomingEdges();
    }

    public Iterable<LEdge> getConnectedEdges() {
        return this.connectedEdges;
    }

    public List<LEdge> getConnectedEdgesAsList() {
        return MesUtilMethods.iterableToList(this.getConnectedEdges());
    }

    public boolean isConnectedToExternalNodes() {
        return this.connectedToExternalNodes;
    }

    public void setConnectedToExternalNodes(boolean conn) {
        this.connectedToExternalNodes = conn;
    }

    public Iterable<LPort> getPredecessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.incomingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)edgesIter.next()).getSource();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public Iterable<LPort> getSuccessorPorts() {
        return new Iterable<LPort>(){

            @Override
            public Iterator<LPort> iterator() {
                final Iterator edgesIter = LPort.this.outgoingEdges.iterator();
                return new Iterator<LPort>(){

                    @Override
                    public boolean hasNext() {
                        return edgesIter.hasNext();
                    }

                    @Override
                    public LPort next() {
                        return ((LEdge)edgesIter.next()).getTarget();
                    }

                    @Override
                    public void remove() {
                        edgesIter.remove();
                    }
                };
            }
        };
    }

    public int getNumberOfConnectedPorts() {
        return (int)this.getConnectedEdgesAsStream().count();
    }

    public Iterable<LPort> getConnectedPorts() {
        return Iterables.concat(this.getPredecessorPorts(), this.getSuccessorPorts());
    }

    public Stream<LPort> getConnectedPortsAsStream() {
        return StreamSupport.stream(this.getConnectedPorts().spliterator(), false);
    }

    public List<LPort> getConnectedPortsAsList() {
        return MesUtilMethods.iterableToList(this.getConnectedPorts());
    }

    public List<LPort> getConnectedPorts(PortSide portSide) {
        return this.getConnectedPortsAsStream().filter(p -> p.getSide() == portSide).collect(Collectors.toList());
    }

    public LPort getFirstConnectedPort() {
        return this.getConnectedPortsAsStream().findFirst().orElse(null);
    }

    public List<LPort> getDistinctConnectedPortsInOtherLayer() {
        return this.getDistinctConnectedPortsInOtherLayerAsStream().collect(Collectors.toList());
    }

    public long getNumberOfDistinctConnectedPortsInOtherLayer() {
        return this.getDistinctConnectedPortsInOtherLayerAsStream().count();
    }

    private Stream<LPort> getDistinctConnectedPortsInOtherLayerAsStream() {
        return this.getConnectedPortsAsList().stream().filter(p -> p.getNode().getLayer() != this.getNode().getLayer()).distinct();
    }

    public List<LNode> getConnectedNodes() {
        return this.getConnectedPortsAsList().stream().map(p -> p.getNode()).distinct().collect(Collectors.toList());
    }

    public List<LNode> getConnectedNodes(boolean forward) {
        return this.getEdges(forward).stream().map(e -> e.getOther(this).getNode()).distinct().collect(Collectors.toList());
    }

    public List<LNode> getConnectedNodesInNextLayerFromTopToBottom(boolean forward) {
        return this.getConnectedNodesInGivenLayerFromTopToBottom(forward, this.getNode().getLayer().getNextLayer(forward));
    }

    public List<LNode> getConnectedNodesInSameLayerFromTopToBottom(boolean forward) {
        return this.getConnectedNodesInGivenLayerFromTopToBottom(forward, this.getNode().getLayer());
    }

    public List<LNode> getConnectedNodesInGivenLayerFromTopToBottom(boolean forward, Layer layerOfNodes) {
        return this.getConnectedNodes(forward).stream().filter(cn -> cn.getLayer() == layerOfNodes).sorted(Comparator.comparingInt(LNode::getIndex)).collect(Collectors.toList());
    }

    public List<LNode> getTrueTargetNodes() {
        return this.getConnectedTrueNodes(true);
    }

    public List<LNode> getTrueSourceNodes() {
        return this.getConnectedTrueNodes(false);
    }

    public LPort getSourceSkippingLongEdgeDummies() {
        if (this.getIncomingEdges().isEmpty()) {
            return null;
        }
        LEdge inEdge = this.getIncomingEdges().get(0);
        LNode sourceNode = inEdge.getSourceNode();
        return sourceNode.isLongEdge() ? sourceNode.getProperty(InternalProperties.LONG_EDGE_SOURCE) : inEdge.getSource();
    }

    public boolean isAbove(LPort port) {
        return this.isAboveOrBelowOrEqual(port, (y1, y2) -> y1 < y2);
    }

    public boolean isAboveOrEqual(LPort port) {
        return this.isAboveOrBelowOrEqual(port, (y1, y2) -> y1 <= y2);
    }

    public boolean isBelow(LPort port) {
        return this.isAboveOrBelowOrEqual(port, (y1, y2) -> y1 > y2);
    }

    public boolean isBelowOrEqual(LPort port) {
        return this.isAboveOrBelowOrEqual(port, (y1, y2) -> y1 >= y2);
    }

    private boolean isAboveOrBelowOrEqual(LPort port, BiPredicate<Double, Double> predicate) {
        if (this.getNode() == port.getNode()) {
            return predicate.test(this.getPosition().y, port.getPosition().y);
        }
        assert (this.getNode().getLayer() == port.getNode().getLayer());
        return predicate.test(Double.valueOf(this.getNode().getIndex()), Double.valueOf(port.getNode().getIndex()));
    }

    public boolean isNeighborOf(LPort port) {
        if (this.isOnSameNodeAs(port) && this.isOnSameSideAs(port)) {
            assert (!port.isNorthOrSouthPort()) : "Not yet implemented for north and south ports";
            List<LPort> portsOnSide = this.getNode().getPortsSortedTopToBottom(this.side);
            return Math.abs(portsOnSide.indexOf(this) - portsOnSide.indexOf(port)) == 1;
        }
        return false;
    }

    public int getIndex() {
        if (this.owner == null) {
            return -1;
        }
        return this.owner.getPorts().indexOf(this);
    }

    public int getTrueSideIndex() {
        return this.owner.getTruePortsSortedTopToBottom(this.getSide()).indexOf(this);
    }

    public LNode getPortDummyNode() {
        return this.getProperty(InternalProperties.PORT_DUMMY);
    }

    public LPort getDummyPort(boolean forward) {
        LNode dummyNode = this.getPortDummyNode();
        return dummyNode == null ? null : this.getDummyPort(dummyNode, forward);
    }

    private LPort getDummyPort(LNode dummyNode, boolean forward) {
        if (forward) {
            return dummyNode.getPorts(PortType.INPUT).iterator().next();
        }
        return dummyNode.getPorts(PortType.OUTPUT).iterator().next();
    }

    @Override
    public String getDesignation() {
        if (!this.labels.isEmpty() && !Strings.isNullOrEmpty((String)this.labels.get(0).getText())) {
            return this.labels.get(0).getText();
        }
        String id = super.getDesignation();
        if (id != null) {
            return id;
        }
        return Integer.toString(this.getIndex());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("p_").append(this.getDesignation());
        if (this.owner != null) {
            result.append("[").append(this.owner).append("]");
        }
        if (this.incomingEdges.size() == 1 && this.outgoingEdges.isEmpty() && this.incomingEdges.get(0).getSource() != this) {
            LPort source = this.incomingEdges.get(0).getSource();
            result.append(" << ").append(source.getDesignation());
            result.append("[").append(source.owner).append("]");
        }
        if (this.incomingEdges.isEmpty() && this.outgoingEdges.size() == 1 && this.outgoingEdges.get(0).getTarget() != this) {
            LPort target = this.outgoingEdges.get(0).getTarget();
            result.append(" >> ").append(target.getDesignation());
            result.append("[").append(target.owner).append("]");
        }
        return result.toString();
    }

    public boolean labelWasRemovedByLabelMerger() {
        return this.labelWasRemovedByLabelMerger;
    }

    public void setLabelWasRemovedByLabelMerger(boolean labelWasRemovedByLabelMerger) {
        this.labelWasRemovedByLabelMerger = labelWasRemovedByLabelMerger;
    }

    private List<LNode> getConnectedTrueNodes(boolean target) {
        Stream<LNode> connectedNodes = target ? this.getOutgoingEdges().stream().map(e -> e.getTargetNode()) : this.getIncomingEdges().stream().map(e -> e.getSourceNode());
        return connectedNodes.map(n -> n.getTrueNode()).collect(Collectors.toList());
    }

    public Stream<LEdge> getConnectedEdgesAsStream() {
        return StreamSupport.stream(this.getConnectedEdges().spliterator(), false);
    }

    private static class CombineIter<T>
    implements Iterable<T> {
        private Iterable<T> firstIterable;
        private Iterable<T> secondIterable;

        CombineIter(Iterable<T> firstIterable, Iterable<T> secondIterable) {
            this.firstIterable = firstIterable;
            this.secondIterable = secondIterable;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private Iterator<T> firstIterator;
                private Iterator<T> secondIterator;
                {
                    this.firstIterator = combineIter.firstIterable.iterator();
                    this.secondIterator = combineIter.secondIterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.firstIterator.hasNext() || this.secondIterator.hasNext();
                }

                @Override
                public T next() {
                    if (this.firstIterator.hasNext()) {
                        return this.firstIterator.next();
                    }
                    return this.secondIterator.next();
                }
            };
        }
    }
}

