/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LEdge;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LLabel;
import com.modelengineers.MoRe_elk.alg.layered.graph.LMargin;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPadding;
import com.modelengineers.MoRe_elk.alg.layered.graph.LPort;
import com.modelengineers.MoRe_elk.alg.layered.graph.LShape;
import com.modelengineers.MoRe_elk.alg.layered.graph.Layer;
import com.modelengineers.MoRe_elk.alg.layered.options.InternalProperties;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.core.math.ElkMargin;
import com.modelengineers.MoRe_elk.core.math.ElkPadding;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.LabelSide;
import com.modelengineers.MoRe_elk.core.options.PortSide;
import com.modelengineers.MoRe_elk.core.util.adapters.GraphAdapters;
import com.modelengineers.MoRe_elk.graph.properties.IProperty;
import com.modelengineers.MoRe_elk.graph.properties.MapPropertyHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;

public final class LGraphAdapters {
    public static final PortComparator DEFAULT_PORTLIST_SORTER = new PortComparator();

    private LGraphAdapters() {
        throw new IllegalStateException("Private constructor, not to be instantiated!");
    }

    public static LGraphAdapter adapt(LGraph graph) {
        return LGraphAdapters.adapt(graph, false);
    }

    public static LGraphAdapter adapt(LGraph graph, boolean transparentNorthSouthEdges) {
        return new LGraphAdapter(graph, transparentNorthSouthEdges, false, n -> true);
    }

    public static LGraphAdapter adapt(LGraph graph, boolean transparentNorthSouthEdges, boolean transparentCommentNodes, Predicate<LNode> nodeFilter) {
        return new LGraphAdapter(graph, transparentNorthSouthEdges, transparentCommentNodes, nodeFilter);
    }

    public static LNodeAdapter adapt(LNode node, boolean transparentNorthSouthEdges) {
        return new LNodeAdapter(null, node, transparentNorthSouthEdges);
    }

    public static LLabelAdapter adapt(LLabel label) {
        return new LLabelAdapter(label);
    }

    private static abstract class AbstractLShapeAdapter<T extends LShape>
    implements GraphAdapters.GraphElementAdapter<T> {
        protected T element;

        AbstractLShapeAdapter(T element) {
            this.element = element;
        }

        @Override
        public KVector getSize() {
            return ((LShape)this.element).getSize();
        }

        @Override
        public void setSize(KVector size) {
            ((LShape)this.element).getSize().x = size.x;
            ((LShape)this.element).getSize().y = size.y;
        }

        @Override
        public KVector getPosition() {
            return ((LShape)this.element).getPosition();
        }

        @Override
        public void setPosition(KVector pos) {
            ((LShape)this.element).getPosition().x = pos.x;
            ((LShape)this.element).getPosition().y = pos.y;
        }

        @Override
        public <P> P getProperty(IProperty<P> prop) {
            return ((MapPropertyHolder)this.element).getProperty(prop);
        }

        @Override
        public <P> boolean hasProperty(IProperty<P> prop) {
            return ((MapPropertyHolder)this.element).hasProperty(prop);
        }

        @Override
        public int getVolatileId() {
            return ((LShape)this.element).id;
        }

        @Override
        public void setVolatileId(int volatileId) {
            ((LShape)this.element).id = volatileId;
        }
    }

    static final class LEdgeAdapter
    implements GraphAdapters.EdgeAdapter<LEdge> {
        private LEdge element;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;

        LEdgeAdapter(LEdge edge) {
            this.element = edge;
        }

        @Override
        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)this.element.getLabels().size());
                for (LLabel l : this.element.getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }
    }

    public static final class LGraphAdapter
    implements GraphAdapters.GraphAdapter<LGraph> {
        protected final LGraph element;
        private List<GraphAdapters.NodeAdapter<?>> nodeAdapters = null;
        private final boolean transparentNorthSouthEdges;
        private final boolean transparentCommentNodes;
        private final Predicate<LNode> nodeFilter;

        private LGraphAdapter(LGraph element, boolean transparentNorthSouthEdges, boolean transparentCommentNodes, Predicate<LNode> nodeFilter) {
            this.element = element;
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
            this.transparentCommentNodes = transparentCommentNodes;
            this.nodeFilter = nodeFilter;
        }

        @Override
        public KVector getSize() {
            return this.element.getSize();
        }

        @Override
        public void setSize(KVector size) {
            this.element.getSize().x = size.x;
            this.element.getSize().y = size.y;
        }

        @Override
        public KVector getPosition() {
            throw new UnsupportedOperationException("Not supported by LGraph");
        }

        @Override
        public void setPosition(KVector pos) {
            throw new UnsupportedOperationException("Not supported by LGraph");
        }

        @Override
        public <P> P getProperty(IProperty<P> prop) {
            return this.element.getProperty(prop);
        }

        @Override
        public <P> boolean hasProperty(IProperty<P> prop) {
            return this.element.hasProperty(prop);
        }

        @Override
        public Iterable<GraphAdapters.NodeAdapter<?>> getNodes() {
            if (this.nodeAdapters == null) {
                this.nodeAdapters = Lists.newArrayList();
                for (Layer l : this.element.getLayers()) {
                    for (LNode n : l.getNodes()) {
                        if (!this.nodeFilter.test(n)) continue;
                        this.nodeAdapters.add(new LNodeAdapter(this, n, this.transparentNorthSouthEdges));
                        if (!this.transparentCommentNodes) continue;
                        if (n.hasProperty(InternalProperties.TOP_COMMENTS)) {
                            for (LNode comment : n.getProperty(InternalProperties.TOP_COMMENTS)) {
                                this.nodeAdapters.add(new LNodeAdapter(this, comment, false));
                            }
                        }
                        if (!n.hasProperty(InternalProperties.BOTTOM_COMMENTS)) continue;
                        for (LNode comment : n.getProperty(InternalProperties.BOTTOM_COMMENTS)) {
                            this.nodeAdapters.add(new LNodeAdapter(this, comment, false));
                        }
                    }
                }
            }
            return this.nodeAdapters;
        }

        @Override
        public int getVolatileId() {
            return this.element.id;
        }

        @Override
        public void setVolatileId(int volatileId) {
            this.element.id = volatileId;
        }
    }

    static final class LLabelAdapter
    extends AbstractLShapeAdapter<LLabel>
    implements GraphAdapters.LabelAdapter<LLabel> {
        LLabelAdapter(LLabel element) {
            super(element);
        }

        @Override
        public LabelSide getSide() {
            return ((LLabel)this.element).getProperty(LabelSide.LABEL_SIDE);
        }

        @Override
        public String getText() {
            return ((LLabel)this.element).getText();
        }
    }

    static final class LNodeAdapter
    extends AbstractLShapeAdapter<LNode>
    implements GraphAdapters.NodeAdapter<LNode> {
        private LGraphAdapter parentGraphAdapter = null;
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.PortAdapter<?>> portAdapters = null;
        private boolean transparentNorthSouthEdges;

        LNodeAdapter(LGraphAdapter parent, LNode element, boolean transparentNorthSouthEdges) {
            super(element);
            this.parentGraphAdapter = parent;
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
        }

        @Override
        public GraphAdapters.GraphAdapter<?> getGraph() {
            return this.parentGraphAdapter;
        }

        @Override
        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)((LNode)this.element).getLabels().size());
                for (LLabel l : ((LNode)this.element).getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public Iterable<GraphAdapters.PortAdapter<?>> getPorts() {
            if (this.portAdapters == null) {
                this.portAdapters = Lists.newArrayListWithCapacity((int)((LNode)this.element).getPorts().size());
                for (LPort p : ((LNode)this.element).getPorts()) {
                    this.portAdapters.add(new LPortAdapter(p, this.transparentNorthSouthEdges));
                }
            }
            return this.portAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            return Collections.emptyList();
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            return Collections.emptyList();
        }

        @Override
        public void sortPortList() {
            this.sortPortList(DEFAULT_PORTLIST_SORTER);
        }

        @Override
        public void sortPortList(Comparator<?> comparator) {
            if (((LNode)this.element).getProperty(LayeredOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                Collections.sort(((LNode)this.element).getPorts(), comparator);
            }
        }

        @Override
        public boolean isCompoundNode() {
            return ((LNode)this.element).getProperty(InternalProperties.COMPOUND_NODE);
        }

        @Override
        public ElkPadding getPadding() {
            LPadding lPadding = ((LNode)this.element).getPadding();
            return new ElkPadding(lPadding.top, lPadding.right, lPadding.bottom, lPadding.left);
        }

        @Override
        public void setPadding(ElkPadding padding) {
            ((LNode)this.element).getPadding().left = padding.left;
            ((LNode)this.element).getPadding().top = padding.top;
            ((LNode)this.element).getPadding().right = padding.right;
            ((LNode)this.element).getPadding().bottom = padding.bottom;
        }

        @Override
        public ElkMargin getMargin() {
            LMargin lmargins = ((LNode)this.element).getMargin();
            return new ElkMargin(lmargins.top, lmargins.right, lmargins.bottom, lmargins.left);
        }

        @Override
        public void setMargin(ElkMargin margin) {
            ((LNode)this.element).getMargin().left = margin.left;
            ((LNode)this.element).getMargin().top = margin.top;
            ((LNode)this.element).getMargin().right = margin.right;
            ((LNode)this.element).getMargin().bottom = margin.bottom;
        }
    }

    static final class LPortAdapter
    extends AbstractLShapeAdapter<LPort>
    implements GraphAdapters.PortAdapter<LPort> {
        private List<GraphAdapters.LabelAdapter<?>> labelAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> incomingEdgeAdapters = null;
        private List<GraphAdapters.EdgeAdapter<?>> outgoingEdgeAdapters = null;
        private boolean transparentNorthSouthEdges;

        LPortAdapter(LPort element, boolean transparentNorthSouthEdges) {
            super(element);
            this.transparentNorthSouthEdges = transparentNorthSouthEdges;
        }

        @Override
        public PortSide getSide() {
            return ((LPort)this.element).getSide();
        }

        @Override
        public Iterable<GraphAdapters.LabelAdapter<?>> getLabels() {
            if (this.labelAdapters == null) {
                this.labelAdapters = Lists.newArrayListWithCapacity((int)((LPort)this.element).getLabels().size());
                for (LLabel l : ((LPort)this.element).getLabels()) {
                    this.labelAdapters.add(new LLabelAdapter(l));
                }
            }
            return this.labelAdapters;
        }

        @Override
        public ElkMargin getMargin() {
            LMargin lmargins = ((LPort)this.element).getMargin();
            return new ElkMargin(lmargins.top, lmargins.right, lmargins.bottom, lmargins.left);
        }

        @Override
        public void setMargin(ElkMargin margin) {
            ((LPort)this.element).getMargin().left = margin.left;
            ((LPort)this.element).getMargin().top = margin.top;
            ((LPort)this.element).getMargin().right = margin.right;
            ((LPort)this.element).getMargin().bottom = margin.bottom;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getIncomingEdges() {
            if (this.transparentNorthSouthEdges && ((LPort)this.element).getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                return Collections.emptyList();
            }
            if (this.incomingEdgeAdapters == null) {
                LNode portDummy;
                this.incomingEdgeAdapters = Lists.newArrayList();
                for (LEdge e : ((LPort)this.element).getIncomingEdges()) {
                    this.incomingEdgeAdapters.add(new LEdgeAdapter(e));
                }
                if (this.transparentNorthSouthEdges && (portDummy = ((LPort)this.element).getProperty(InternalProperties.PORT_DUMMY)) != null) {
                    for (LEdge e : portDummy.getIncomingEdges()) {
                        this.incomingEdgeAdapters.add(new LEdgeAdapter(e));
                    }
                }
            }
            return this.incomingEdgeAdapters;
        }

        @Override
        public Iterable<GraphAdapters.EdgeAdapter<?>> getOutgoingEdges() {
            if (this.transparentNorthSouthEdges && ((LPort)this.element).getNode().getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                return Collections.emptyList();
            }
            if (this.outgoingEdgeAdapters == null) {
                LNode portDummy;
                this.outgoingEdgeAdapters = Lists.newArrayList();
                for (LEdge e : ((LPort)this.element).getOutgoingEdges()) {
                    this.outgoingEdgeAdapters.add(new LEdgeAdapter(e));
                }
                if (this.transparentNorthSouthEdges && (portDummy = ((LPort)this.element).getProperty(InternalProperties.PORT_DUMMY)) != null) {
                    for (LEdge e : portDummy.getOutgoingEdges()) {
                        this.outgoingEdgeAdapters.add(new LEdgeAdapter(e));
                    }
                }
            }
            return this.outgoingEdgeAdapters;
        }

        @Override
        public boolean hasCompoundConnections() {
            return ((LPort)this.element).getProperty(InternalProperties.INSIDE_CONNECTIONS);
        }
    }

    public static class PortComparator
    implements Comparator<LPort> {
        @Override
        public int compare(LPort port1, LPort port2) {
            int indexDifference;
            int ordinalDifference = port1.getSide().ordinal() - port2.getSide().ordinal();
            if (ordinalDifference != 0) {
                return ordinalDifference;
            }
            Integer index1 = port1.getProperty(LayeredOptions.PORT_INDEX);
            Integer index2 = port2.getProperty(LayeredOptions.PORT_INDEX);
            if (index1 != null && index2 != null && (indexDifference = index1 - index2) != 0) {
                return indexDifference;
            }
            switch (port1.getSide()) {
                case NORTH: {
                    return Double.compare(port1.getPosition().x, port2.getPosition().x);
                }
                case EAST: {
                    return Double.compare(port1.getPosition().y, port2.getPosition().y);
                }
                case SOUTH: {
                    return Double.compare(port2.getPosition().x, port1.getPosition().x);
                }
                case WEST: {
                    return Double.compare(port2.getPosition().y, port1.getPosition().y);
                }
            }
            throw new IllegalStateException("Port side is undefined");
        }
    }
}

