/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered.graph;

import com.google.common.collect.Lists;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraph;
import com.modelengineers.MoRe_elk.alg.layered.graph.LGraphElement;
import com.modelengineers.MoRe_elk.alg.layered.graph.LNode;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class Component
extends LGraphElement
implements Iterable<LNode> {
    private static final long serialVersionUID = 5079195469603516033L;
    private final LGraph owner;
    private final List<LNode> nodes = Lists.newArrayList();

    public Component(LGraph graph) {
        this.owner = graph;
    }

    public int getNumberOfNormalNodes() {
        return this.nodes.stream().filter(n -> n.getNestedGraph() == null && n.getType() == LNode.NodeType.NORMAL).collect(Collectors.toList()).size();
    }

    public List<LNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Iterator<LNode> iterator() {
        return this.nodes.iterator();
    }

    public LGraph getGraph() {
        return this.owner;
    }

    public int getIndex() {
        return this.owner.getComponents().indexOf(this);
    }

    public String toString() {
        return "C_" + this.getIndex() + this.nodes.toString();
    }
}

