/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.layered;

import com.modelengineers.MoRe_elk.alg.layered.options.CycleBreakingStrategy;
import com.modelengineers.MoRe_elk.alg.layered.options.LayerConstraint;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeredOptions;
import com.modelengineers.MoRe_elk.alg.layered.options.LayeringStrategy;
import com.modelengineers.MoRe_elk.core.math.KVector;
import com.modelengineers.MoRe_elk.core.options.CoreOptions;
import com.modelengineers.MoRe_elk.core.util.IGraphElementVisitor;
import com.modelengineers.MoRe_elk.graph.ElkConnectableShape;
import com.modelengineers.MoRe_elk.graph.ElkEdge;
import com.modelengineers.MoRe_elk.graph.ElkGraphElement;
import com.modelengineers.MoRe_elk.graph.ElkNode;
import com.modelengineers.MoRe_elk.graph.ElkPort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InteractiveLayeredGraphVisitor
implements IGraphElementVisitor {
    public static final int PSEUDO_POSITION_SPACING = Integer.MAX_VALUE;
    public static final int LAST_LAYER_INDEX = Integer.MAX_VALUE;

    @Override
    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode) {
            ElkNode root = (ElkNode)element;
            this.setInteractiveOptionsAndPseudoPositions(root);
        }
    }

    private void setInteractiveOptionsAndPseudoPositions(ElkNode root) {
        String algorithm;
        if (!root.getChildren().isEmpty() && ((algorithm = root.getProperty(CoreOptions.ALGORITHM)) == null || "com.modelengineers.MoRe_elk.layered".endsWith(algorithm))) {
            for (ElkNode node : root.getChildren()) {
                if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
                    node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, LayerConstraint.NONE);
                }
                this.setCoordinates(root);
                this.setInteractiveStrategies(root);
            }
        }
    }

    private void setCoordinates(ElkNode root) {
        List<List<ElkNode>> layers = this.calcLayerNodes(root.getChildren());
        this.setCoordinateInLayoutDirection(layers);
        int layerId = 0;
        for (List<ElkNode> layer : layers) {
            if (layer.size() <= 0) continue;
            this.setCoordinatesOrthogonalToLayoutDirection(layer, layerId);
            ++layerId;
        }
    }

    private List<List<ElkNode>> calcLayerNodes(List<ElkNode> nodes) {
        ArrayList<ElkNode> allNodes = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithLayerConstraint = new ArrayList<ElkNode>();
        for (ElkNode node : nodes) {
            allNodes.add(node);
            if (node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) == -1) continue;
            nodesWithLayerConstraint.add(node);
        }
        List<List<ElkNode>> layerNodes = this.initialLayers(allNodes);
        this.assignLayersToNodesWithProperty(nodesWithLayerConstraint, layerNodes);
        return layerNodes;
    }

    private void assignLayersToNodesWithProperty(List<ElkNode> nodesWithLayerConstraint, List<List<ElkNode>> layering) {
        nodesWithLayerConstraint.sort((a, b) -> a.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - b.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT));
        int diff = 0;
        for (ElkNode node : nodesWithLayerConstraint) {
            int currentLayer = node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - diff;
            if (currentLayer < layering.size()) {
                List<ElkNode> nodesOfLayer = layering.get(currentLayer);
                this.shiftOtherNodes(node, currentLayer, layering, true);
                this.shiftOtherNodes(node, currentLayer, layering, false);
                nodesOfLayer.add(node);
                continue;
            }
            diff = diff + currentLayer - layering.size();
            layering.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
    }

    private void shiftOtherNodes(ElkNode movedNode, int layer, List<List<ElkNode>> layerNodes, boolean incoming) {
        ElkNode root;
        List<ElkNode> nodesOfLayer = layerNodes.get(layer);
        ArrayList<ElkEdge> edges = new ArrayList<ElkEdge>();
        if (incoming) {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getTargets()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        } else {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getSources()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        }
        for (ElkEdge edge : edges) {
            ElkNode node = null;
            if (incoming) {
                if (edge.getSources().get(0) instanceof ElkPort) {
                    node = (ElkNode)((ElkConnectableShape)edge.getSources().get(0)).eContainer();
                } else if (edge.getSources().get(0) instanceof ElkNode) {
                    node = (ElkNode)edge.getSources().get(0);
                }
            } else if (edge.getTargets().get(0) instanceof ElkPort) {
                node = (ElkNode)((ElkConnectableShape)edge.getTargets().get(0)).eContainer();
            } else if (edge.getTargets().get(0) instanceof ElkNode) {
                node = (ElkNode)edge.getTargets().get(0);
            }
            if (!nodesOfLayer.contains(node)) continue;
            nodesOfLayer.remove(node);
            if (layer + 1 < layerNodes.size()) {
                List<ElkNode> newLayer = layerNodes.get(layer + 1);
                newLayer.add(node);
                this.shiftOtherNodes(node, layer + 1, layerNodes, false);
                this.shiftOtherNodes(node, layer + 1, layerNodes, true);
                continue;
            }
            layerNodes.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
    }

    private List<List<ElkNode>> initialLayers(ArrayList<ElkNode> nodes) {
        nodes.sort((a, b) -> a.getProperty(LayeredOptions.LAYERING_LAYER_ID) - b.getProperty(LayeredOptions.LAYERING_LAYER_ID));
        ArrayList<List<ElkNode>> layerNodes = new ArrayList<List<ElkNode>>();
        ArrayList<ElkNode> nodesOfLayer = new ArrayList<ElkNode>();
        int currentLayer = -1;
        for (ElkNode node : nodes) {
            int layer = node.getProperty(LayeredOptions.LAYERING_LAYER_ID);
            if (layer > currentLayer) {
                if (!nodesOfLayer.isEmpty()) {
                    layerNodes.add(nodesOfLayer);
                }
                nodesOfLayer = new ArrayList();
                currentLayer = layer;
            }
            if (node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) != -1) continue;
            nodesOfLayer.add(node);
        }
        if (!nodesOfLayer.isEmpty()) {
            layerNodes.add(nodesOfLayer);
        }
        return layerNodes;
    }

    private void setCoordinateInLayoutDirection(List<List<ElkNode>> layers) {
        double position = 0.0;
        double nextPosition = 0.0;
        for (List<ElkNode> nodesOfLayer : layers) {
            for (ElkNode node : nodesOfLayer) {
                node.setX(position);
                if (!(position + node.getWidth() / 2.0 >= nextPosition)) continue;
                nextPosition = node.getX() + node.getWidth() + 2.147483647E9;
            }
            position = nextPosition;
        }
    }

    private void setCoordinatesOrthogonalToLayoutDirection(List<ElkNode> nodesOfLayer, int layerId) {
        ArrayList<ElkNode> nodesWithPositionConstraint = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodes = new ArrayList<ElkNode>();
        for (ElkNode node : nodesOfLayer) {
            if (node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) != -1) {
                nodesWithPositionConstraint.add(node);
                continue;
            }
            nodes.add(node);
        }
        this.sortNodesInLayer(nodesWithPositionConstraint, nodes);
        for (ElkNode node : nodesWithPositionConstraint) {
            int pos = node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
            if (pos < nodes.size()) {
                nodes.add(pos, node);
                continue;
            }
            nodes.add(node);
        }
        double yPos = ((ElkNode)nodes.get(0)).getY();
        for (ElkNode node : nodes) {
            node.setProperty(LayeredOptions.POSITION, new KVector(node.getX(), yPos));
            yPos += node.getHeight() + 2.147483647E9;
        }
    }

    private void sortNodesInLayer(List<ElkNode> nodesWithPositionConstraint, List<ElkNode> nodes) {
        nodesWithPositionConstraint.sort((a, b) -> a.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) - b.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT));
        nodes.sort((a, b) -> (int)(a.getY() - b.getY()));
    }

    private void setInteractiveStrategies(ElkNode parent) {
        parent.setProperty(LayeredOptions.LAYERING_STRATEGY, LayeringStrategy.INTERACTIVE);
        parent.setProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY, CycleBreakingStrategy.INTERACTIVE);
    }
}

