/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem;

import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.AtomicCell;
import com.modelengineers.MoRe_elk.alg.common.nodespacing.cellsystem.Cell;
import com.modelengineers.MoRe_elk.core.math.ElkRectangle;

public abstract class ContainerCell
extends Cell {
    public abstract void layoutChildrenHorizontally();

    public abstract void layoutChildrenVertically();

    protected static double minWidthOfCell(Cell cell, boolean respectContributionFlag) {
        if (cell == null) {
            return 0.0;
        }
        if (respectContributionFlag && !cell.isContributingToMinimumWidth()) {
            return 0.0;
        }
        if (cell instanceof AtomicCell && ((AtomicCell)cell).getMinimumContentAreaSize().x == 0.0) {
            return 0.0;
        }
        return cell.getMinimumWidth();
    }

    protected static double minHeightOfCell(Cell cell, boolean respectContributionFlag) {
        if (cell == null) {
            return 0.0;
        }
        if (respectContributionFlag && !cell.isContributingToMinimumHeight()) {
            return 0.0;
        }
        if (cell instanceof AtomicCell && ((AtomicCell)cell).getMinimumContentAreaSize().y == 0.0) {
            return 0.0;
        }
        return cell.getMinimumHeight();
    }

    protected void applyHorizontalLayout(Cell cell, double x, double width) {
        if (cell != null) {
            ElkRectangle cellRect = cell.getCellRectangle();
            cellRect.x = x;
            cellRect.width = width;
        }
    }

    protected void applyVerticalLayout(Cell cell, double y, double height) {
        if (cell != null) {
            ElkRectangle cellRect = cell.getCellRectangle();
            cellRect.y = y;
            cellRect.height = height;
        }
    }
}

