/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.networksimplex;

import com.modelengineers.MoRe_elk.alg.common.networksimplex.NNode;

public class NEdge {
    public int id;
    protected int internalId;
    public Object origin;
    public NNode source;
    public NNode target;
    public double weight;
    public int delta = 1;
    protected boolean treeEdge = false;

    public static NEdgeBuilder of() {
        return new NEdgeBuilder();
    }

    public static NEdgeBuilder of(Object origin) {
        return new NEdgeBuilder();
    }

    public NNode getSource() {
        return this.source;
    }

    public NNode getTarget() {
        return this.target;
    }

    public NNode getOther(NNode some) {
        if (some == this.source) {
            return this.target;
        }
        if (some == this.target) {
            return this.source;
        }
        throw new IllegalArgumentException("Node " + some + " not part of edge " + this);
    }

    public NEdge reverse() {
        NNode tmp = this.source;
        this.source = this.target;
        this.target = tmp;
        this.target.getOutgoingEdges().remove(this);
        this.target.getIncomingEdges().add(this);
        this.source.getIncomingEdges().remove(this);
        this.source.getOutgoingEdges().add(this);
        return this;
    }

    public String toString() {
        return "NEdge[id=" + this.id + " w=" + this.weight + " d=" + this.delta + "]";
    }

    public static final class NEdgeBuilder {
        private NEdge edge = new NEdge();

        private NEdgeBuilder() {
        }

        public NEdgeBuilder id(int id) {
            this.edge.id = id;
            return this;
        }

        public NEdgeBuilder origin(Object origin) {
            this.edge.origin = origin;
            return this;
        }

        public NEdgeBuilder weight(double weight) {
            this.edge.weight = weight;
            return this;
        }

        public NEdgeBuilder delta(int delta) {
            this.edge.delta = delta;
            return this;
        }

        public NEdgeBuilder source(NNode source) {
            this.edge.source = source;
            return this;
        }

        public NEdgeBuilder target(NNode target) {
            this.edge.target = target;
            return this;
        }

        public NEdge create() {
            if (this.edge.source == null || this.edge.target == null) {
                throw new IllegalStateException(String.valueOf(NEdge.class.getSimpleName()) + " must have a source and target " + NNode.class.getSimpleName() + " specified.");
            }
            if (this.edge.source == this.edge.target) {
                throw new IllegalStateException("Network simplex does not support self-loops: " + this.edge + " " + this.edge.source + " " + this.edge.target);
            }
            this.edge.source.getOutgoingEdges().add(this.edge);
            this.edge.target.getIncomingEdges().add(this.edge);
            return this.edge;
        }
    }
}

