/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe_elk.alg.common.compaction;

import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CGraph;
import com.modelengineers.MoRe_elk.alg.common.compaction.oned.CNode;
import com.modelengineers.MoRe_elk.core.math.KVector;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static void drawHitboxes(CGraph cGraph, String fileName) {
        KVector topLeft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomRight = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (CNode cNode : cGraph.cNodes) {
            topLeft.x = Math.min(topLeft.x, cNode.hitbox.x);
            topLeft.y = Math.min(topLeft.y, cNode.hitbox.y);
            bottomRight.x = Math.max(bottomRight.x, cNode.hitbox.x + cNode.hitbox.width);
            bottomRight.y = Math.max(bottomRight.y, cNode.hitbox.y + cNode.hitbox.height);
        }
        KVector size = bottomRight.clone().sub(topLeft);
        try {
            PrintWriter out = new PrintWriter(new FileWriter(fileName));
            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%\" height=\"100%\"  viewBox=\"" + topLeft.x + " " + topLeft.y + " " + size.x + " " + size.y + "\">");
            out.println("<defs><marker id=\"markerArrow\" markerWidth=\"10\" markerHeight=\"10\" refX=\"0\" refY=\"3\" orient=\"auto\">  <path d=\"M0,0 L0,6 L9,3 z\" style=\"fill: #000000;\" /></marker></defs>");
            for (CNode cNode : cGraph.cNodes) {
                out.println(cNode.getDebugSVG());
                for (CNode inc : cNode.constraints) {
                    out.println("<line x1=\"" + inc.hitbox.x + "\" y1=\"" + (inc.hitbox.y + inc.hitbox.height / 2.0) + "\" x2=\"" + (cNode.hitbox.x + cNode.hitbox.width) + "\" y2=\"" + (cNode.hitbox.y + cNode.hitbox.height / 2.0) + "\" stroke=\"black\" opacity=\"0.4\"" + " style=\"marker-end: url(#markerArrow);\" />");
                }
            }
            out.println("</svg>");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

