/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.LinearExpr;

public final class WeightedSumExpression
implements LinearExpr {
    private final int[] variablesIndices;
    private final long[] coefficients;
    private final long offset;

    public WeightedSumExpression(int[] variablesIndices, long[] coefficients, long offset) {
        this.variablesIndices = variablesIndices;
        this.coefficients = coefficients;
        this.offset = offset;
    }

    @Override
    public LinearExpr build() {
        return this;
    }

    @Override
    public int numElements() {
        return this.variablesIndices.length;
    }

    @Override
    public int getVariableIndex(int index) {
        if (index < 0 || index >= this.variablesIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getVariable(): " + index);
        }
        return this.variablesIndices[index];
    }

    @Override
    public long getCoefficient(int index) {
        if (index < 0 || index >= this.variablesIndices.length) {
            throw new IllegalArgumentException("wrong index in LinearExpr.getCoefficient(): " + index);
        }
        return this.coefficients[index];
    }

    @Override
    public long getOffset() {
        return this.offset;
    }
}

