/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.sat;

import com.google.ortools.sat.ConstraintProto;
import com.google.ortools.sat.CpModelProto;
import com.google.ortools.sat.IntervalConstraintProto;
import com.google.ortools.sat.LinearExpr;
import com.google.ortools.sat.LinearExpressionProto;

public final class IntervalVar {
    private final CpModelProto.Builder modelBuilder;
    private final int constraintIndex;
    private final IntervalConstraintProto.Builder intervalBuilder;

    IntervalVar(CpModelProto.Builder builder, LinearExpressionProto.Builder startBuilder, LinearExpressionProto.Builder sizeBuilder, LinearExpressionProto.Builder endBuilder, String name) {
        this.modelBuilder = builder;
        this.constraintIndex = this.modelBuilder.getConstraintsCount();
        ConstraintProto.Builder ct = this.modelBuilder.addConstraintsBuilder();
        ct.setName(name);
        this.intervalBuilder = ct.getIntervalBuilder();
        this.intervalBuilder.setStart(startBuilder);
        this.intervalBuilder.setSize(sizeBuilder);
        this.intervalBuilder.setEnd(endBuilder);
    }

    IntervalVar(CpModelProto.Builder builder, LinearExpressionProto.Builder startBuilder, LinearExpressionProto.Builder sizeBuilder, LinearExpressionProto.Builder endBuilder, int isPresentIndex, String name) {
        this.modelBuilder = builder;
        this.constraintIndex = this.modelBuilder.getConstraintsCount();
        ConstraintProto.Builder ct = this.modelBuilder.addConstraintsBuilder();
        ct.setName(name);
        ct.addEnforcementLiteral(isPresentIndex);
        this.intervalBuilder = ct.getIntervalBuilder();
        this.intervalBuilder.setStart(startBuilder);
        this.intervalBuilder.setSize(sizeBuilder);
        this.intervalBuilder.setEnd(endBuilder);
    }

    public String toString() {
        return this.modelBuilder.getConstraints(this.constraintIndex).toString();
    }

    public int getIndex() {
        return this.constraintIndex;
    }

    public IntervalConstraintProto.Builder getBuilder() {
        return this.intervalBuilder;
    }

    public String getName() {
        return this.modelBuilder.getConstraints(this.constraintIndex).getName();
    }

    public LinearExpr getStartExpr() {
        return LinearExpr.rebuildFromLinearExpressionProto(this.intervalBuilder.getStart());
    }

    public LinearExpr getSizeExpr() {
        return LinearExpr.rebuildFromLinearExpressionProto(this.intervalBuilder.getSize());
    }

    public LinearExpr getEndExpr() {
        return LinearExpr.rebuildFromLinearExpressionProto(this.intervalBuilder.getEnd());
    }
}

