/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.SolveStatus;
import com.google.ortools.modelbuilder.mainJNI;
import java.util.function.Consumer;

public class ModelSolverHelper {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ModelSolverHelper(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ModelSolverHelper obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ModelSolverHelper obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_ModelSolverHelper(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public ModelSolverHelper(String solver_name) {
        this(mainJNI.new_ModelSolverHelper(solver_name), true);
    }

    public boolean solverIsSupported() {
        return mainJNI.ModelSolverHelper_solverIsSupported(this.swigCPtr, this);
    }

    public void solve(ModelBuilderHelper model) {
        mainJNI.ModelSolverHelper_solve(this.swigCPtr, this, ModelBuilderHelper.getCPtr(model), model);
    }

    public boolean interruptSolve() {
        return mainJNI.ModelSolverHelper_interruptSolve(this.swigCPtr, this);
    }

    public void setLogCallback(Consumer<String> log_callback) {
        mainJNI.ModelSolverHelper_setLogCallback(this.swigCPtr, this, log_callback);
    }

    public void clearLogCallback() {
        mainJNI.ModelSolverHelper_clearLogCallback(this.swigCPtr, this);
    }

    public boolean hasResponse() {
        return mainJNI.ModelSolverHelper_hasResponse(this.swigCPtr, this);
    }

    public boolean hasSolution() {
        return mainJNI.ModelSolverHelper_hasSolution(this.swigCPtr, this);
    }

    public SolveStatus getStatus() {
        return SolveStatus.swigToEnum(mainJNI.ModelSolverHelper_getStatus(this.swigCPtr, this));
    }

    public double getObjectiveValue() {
        return mainJNI.ModelSolverHelper_getObjectiveValue(this.swigCPtr, this);
    }

    public double getBestObjectiveBound() {
        return mainJNI.ModelSolverHelper_getBestObjectiveBound(this.swigCPtr, this);
    }

    public double getVariableValue(int var_index) {
        return mainJNI.ModelSolverHelper_getVariableValue(this.swigCPtr, this, var_index);
    }

    public double getReducedCost(int var_index) {
        return mainJNI.ModelSolverHelper_getReducedCost(this.swigCPtr, this, var_index);
    }

    public double getDualValue(int ct_index) {
        return mainJNI.ModelSolverHelper_getDualValue(this.swigCPtr, this, ct_index);
    }

    public double getActivity(int ct_index) {
        return mainJNI.ModelSolverHelper_getActivity(this.swigCPtr, this, ct_index);
    }

    public String getStatusString() {
        return mainJNI.ModelSolverHelper_getStatusString(this.swigCPtr, this);
    }

    public double getWallTime() {
        return mainJNI.ModelSolverHelper_getWallTime(this.swigCPtr, this);
    }

    public double getUserTime() {
        return mainJNI.ModelSolverHelper_getUserTime(this.swigCPtr, this);
    }

    public void setTimeLimitInSeconds(double limit) {
        mainJNI.ModelSolverHelper_setTimeLimitInSeconds(this.swigCPtr, this, limit);
    }

    public void setSolverSpecificParameters(String solver_specific_parameters) {
        mainJNI.ModelSolverHelper_setSolverSpecificParameters(this.swigCPtr, this, solver_specific_parameters);
    }

    public void enableOutput(boolean enabled) {
        mainJNI.ModelSolverHelper_enableOutput(this.swigCPtr, this, enabled);
    }
}

