/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.modelbuilder;

import com.google.ortools.modelbuilder.LinearArgument;
import com.google.ortools.modelbuilder.LinearConstraint;
import com.google.ortools.modelbuilder.LinearExpr;
import com.google.ortools.modelbuilder.LinearExprBuilder;
import com.google.ortools.modelbuilder.ModelBuilderHelper;
import com.google.ortools.modelbuilder.Variable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ModelBuilder {
    private final ModelBuilderHelper helper = new ModelBuilderHelper();
    private final Map<Double, Integer> constantMap = new LinkedHashMap<Double, Integer>();

    public Variable newVar(double lb, double ub, boolean isIntegral, String name) {
        return new Variable(this.helper, lb, ub, isIntegral, name);
    }

    public Variable newNumVar(double lb, double ub, String name) {
        return new Variable(this.helper, lb, ub, false, name);
    }

    public Variable newIntVar(double lb, double ub, String name) {
        return new Variable(this.helper, lb, ub, true, name);
    }

    public Variable newBoolVar(String name) {
        return new Variable(this.helper, 0.0, 1.0, true, name);
    }

    public Variable newConstant(double value) {
        if (this.constantMap.containsKey(value)) {
            return new Variable(this.helper, this.constantMap.get(value));
        }
        Variable cste = new Variable(this.helper, value, value, false, "");
        this.constantMap.put(value, cste.getIndex());
        return cste;
    }

    public Variable varFromIndex(int index) {
        return new Variable(this.helper, index);
    }

    public LinearConstraint addLinearConstraint(LinearArgument expr, double lb, double ub) {
        LinearConstraint lin = new LinearConstraint(this.helper);
        LinearExpr e = expr.build();
        for (int i = 0; i < e.numElements(); ++i) {
            this.helper.addConstraintTerm(lin.getIndex(), e.getVariableIndex(i), e.getCoefficient(i));
        }
        double offset = e.getOffset();
        if (lb == Double.NEGATIVE_INFINITY || lb == Double.POSITIVE_INFINITY) {
            lin.setLowerBound(lb);
        } else {
            lin.setLowerBound(lb - offset);
        }
        if (ub == Double.NEGATIVE_INFINITY || ub == Double.POSITIVE_INFINITY) {
            lin.setUpperBound(ub);
        } else {
            lin.setUpperBound(ub - offset);
        }
        return lin;
    }

    public int numVariables() {
        return this.helper.numVariables();
    }

    public LinearConstraint addEquality(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, value, value);
    }

    public LinearConstraint addEquality(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, 0.0, 0.0);
    }

    public LinearConstraint addLessOrEqual(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, Double.NEGATIVE_INFINITY, value);
    }

    public LinearConstraint addLessOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, Double.NEGATIVE_INFINITY, 0.0);
    }

    public LinearConstraint addGreaterOrEqual(LinearArgument expr, double value) {
        return this.addLinearConstraint(expr, value, Double.POSITIVE_INFINITY);
    }

    public LinearConstraint addGreaterOrEqual(LinearArgument left, LinearArgument right) {
        LinearExprBuilder difference = LinearExpr.newBuilder();
        difference.addTerm(left, 1.0);
        difference.addTerm(right, -1.0);
        return this.addLinearConstraint(difference, 0.0, Double.POSITIVE_INFINITY);
    }

    public int numConstraints() {
        return this.helper.numConstraints();
    }

    public void minimize(LinearArgument obj) {
        this.optimize(obj, false);
    }

    public void maximize(LinearArgument obj) {
        this.optimize(obj, true);
    }

    public void optimize(LinearArgument obj, boolean maximize) {
        this.helper.clearObjective();
        LinearExpr e = obj.build();
        LinkedHashMap<Integer, Double> coeffMap = new LinkedHashMap<Integer, Double>();
        for (int i = 0; i < e.numElements(); ++i) {
            coeffMap.merge(e.getVariableIndex(i), e.getCoefficient(i), Double::sum);
        }
        for (Map.Entry entry : coeffMap.entrySet()) {
            if ((Double)entry.getValue() == 0.0) continue;
            this.helper.setVarObjectiveCoefficient((Integer)entry.getKey(), (Double)entry.getValue());
        }
        this.helper.setObjectiveOffset(e.getOffset());
        this.helper.setMaximize(maximize);
    }

    double getObjectiveOffset() {
        return this.helper.getObjectiveOffset();
    }

    void setObjectiveOffset(double offset) {
        this.helper.setObjectiveOffset(offset);
    }

    public String getName() {
        return this.helper.getName();
    }

    public void setName(String name) {
        this.helper.setName(name);
    }

    public boolean exportToFile(String file) {
        return this.helper.writeModelToFile(file);
    }

    public String exportToMpsString(boolean obfuscate) {
        return this.helper.exportToMpsString(obfuscate);
    }

    public String exportToLpString(boolean obfuscate) {
        return this.helper.exportToLpString(obfuscate);
    }

    public boolean importFromMpsString(String mpsString) {
        return this.helper.importFromMpsString(mpsString);
    }

    public boolean importFromMpsFile(String mpsFile) {
        return this.helper.importFromMpsString(mpsFile);
    }

    public boolean importFromLpString(String lpString) {
        return this.helper.importFromLpString(lpString);
    }

    public boolean importFromLpFile(String lpFile) {
        return this.helper.importFromMpsString(lpFile);
    }

    public ModelBuilderHelper getHelper() {
        return this.helper;
    }

    public static class WrongLength
    extends ModelBuilderException {
        public WrongLength(String methodName, String msg) {
            super(methodName, msg);
        }
    }

    public static class MismatchedArrayLengths
    extends ModelBuilderException {
        public MismatchedArrayLengths(String methodName, String array1Name, String array2Name) {
            super(methodName, array1Name + " and " + array2Name + " have mismatched lengths");
        }
    }

    static class ModelBuilderException
    extends RuntimeException {
        public ModelBuilderException(String methodName, String msg) {
            super(methodName + ": " + msg);
        }
    }
}

