/*
 * Decompiled with CFR 0.152.
 */
package com.google.ortools.constraintsolver;

import com.google.ortools.constraintsolver.Constraint;
import com.google.ortools.constraintsolver.IntVar;
import com.google.ortools.constraintsolver.ModelVisitor;
import com.google.ortools.constraintsolver.Solver;
import com.google.ortools.constraintsolver.mainJNI;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

public class Pack
extends Constraint {
    private transient long swigCPtr;

    protected Pack(long cPtr, boolean cMemoryOwn) {
        super(mainJNI.Pack_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Pack obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(Pack obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                mainJNI.delete_Pack(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Pack(Solver s, IntVar[] vars, int number_of_bins) {
        this(mainJNI.new_Pack(Solver.getCPtr(s), s, vars, number_of_bins), true);
    }

    public void addWeightedSumLessOrEqualConstantDimension(long[] weights, long[] bounds) {
        mainJNI.Pack_addWeightedSumLessOrEqualConstantDimension__SWIG_0(this.swigCPtr, this, weights, bounds);
    }

    public void addWeightedSumLessOrEqualConstantDimension(LongUnaryOperator weights, long[] bounds) {
        mainJNI.Pack_addWeightedSumLessOrEqualConstantDimension__SWIG_1(this.swigCPtr, this, weights, bounds);
    }

    public void addWeightedSumLessOrEqualConstantDimension(LongBinaryOperator weights, long[] bounds) {
        mainJNI.Pack_addWeightedSumLessOrEqualConstantDimension__SWIG_2(this.swigCPtr, this, weights, bounds);
    }

    public void addWeightedSumEqualVarDimension(long[] weights, IntVar[] loads) {
        mainJNI.Pack_addWeightedSumEqualVarDimension__SWIG_0(this.swigCPtr, this, weights, loads);
    }

    public void addWeightedSumEqualVarDimension(LongBinaryOperator weights, IntVar[] loads) {
        mainJNI.Pack_addWeightedSumEqualVarDimension__SWIG_1(this.swigCPtr, this, weights, loads);
    }

    public void addSumVariableWeightsLessOrEqualConstantDimension(IntVar[] usage, long[] capacity) {
        mainJNI.Pack_addSumVariableWeightsLessOrEqualConstantDimension(this.swigCPtr, this, usage, capacity);
    }

    public void addWeightedSumOfAssignedDimension(long[] weights, IntVar cost_var) {
        mainJNI.Pack_addWeightedSumOfAssignedDimension(this.swigCPtr, this, weights, IntVar.getCPtr(cost_var), cost_var);
    }

    public void addCountUsedBinDimension(IntVar count_var) {
        mainJNI.Pack_addCountUsedBinDimension(this.swigCPtr, this, IntVar.getCPtr(count_var), count_var);
    }

    public void addCountAssignedItemsDimension(IntVar count_var) {
        mainJNI.Pack_addCountAssignedItemsDimension(this.swigCPtr, this, IntVar.getCPtr(count_var), count_var);
    }

    @Override
    public void post() {
        mainJNI.Pack_post(this.swigCPtr, this);
    }

    public void clearAll() {
        mainJNI.Pack_clearAll(this.swigCPtr, this);
    }

    public void propagateDelayed() {
        mainJNI.Pack_propagateDelayed(this.swigCPtr, this);
    }

    @Override
    public void initialPropagate() {
        mainJNI.Pack_initialPropagate(this.swigCPtr, this);
    }

    public void propagate() {
        mainJNI.Pack_propagate(this.swigCPtr, this);
    }

    public void oneDomain(int var_index) {
        mainJNI.Pack_oneDomain(this.swigCPtr, this, var_index);
    }

    @Override
    public String toString() {
        return mainJNI.Pack_toString(this.swigCPtr, this);
    }

    public boolean isUndecided(int var_index, int bin_index) {
        return mainJNI.Pack_isUndecided(this.swigCPtr, this, var_index, bin_index);
    }

    public void setImpossible(int var_index, int bin_index) {
        mainJNI.Pack_setImpossible(this.swigCPtr, this, var_index, bin_index);
    }

    public void assign(int var_index, int bin_index) {
        mainJNI.Pack_assign(this.swigCPtr, this, var_index, bin_index);
    }

    public boolean isAssignedStatusKnown(int var_index) {
        return mainJNI.Pack_isAssignedStatusKnown(this.swigCPtr, this, var_index);
    }

    public boolean isPossible(int var_index, int bin_index) {
        return mainJNI.Pack_isPossible(this.swigCPtr, this, var_index, bin_index);
    }

    public IntVar assignVar(int var_index, int bin_index) {
        long cPtr = mainJNI.Pack_assignVar(this.swigCPtr, this, var_index, bin_index);
        return cPtr == 0L ? null : new IntVar(cPtr, false);
    }

    public void setAssigned(int var_index) {
        mainJNI.Pack_setAssigned(this.swigCPtr, this, var_index);
    }

    public void setUnassigned(int var_index) {
        mainJNI.Pack_setUnassigned(this.swigCPtr, this, var_index);
    }

    public void removeAllPossibleFromBin(int bin_index) {
        mainJNI.Pack_removeAllPossibleFromBin(this.swigCPtr, this, bin_index);
    }

    public void assignAllPossibleToBin(int bin_index) {
        mainJNI.Pack_assignAllPossibleToBin(this.swigCPtr, this, bin_index);
    }

    public void assignFirstPossibleToBin(int bin_index) {
        mainJNI.Pack_assignFirstPossibleToBin(this.swigCPtr, this, bin_index);
    }

    public void assignAllRemainingItems() {
        mainJNI.Pack_assignAllRemainingItems(this.swigCPtr, this);
    }

    public void unassignAllRemainingItems() {
        mainJNI.Pack_unassignAllRemainingItems(this.swigCPtr, this);
    }

    @Override
    public void accept(ModelVisitor visitor) {
        mainJNI.Pack_accept(this.swigCPtr, this, ModelVisitor.getCPtr(visitor), visitor);
    }
}

