/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.RMIClassLoaderSpi;

public class MatlabRMIClassLoaderSpi
extends RMIClassLoaderSpi {
    private final RMIClassLoaderSpi _delegateLoaderSpi = RMIClassLoader.getDefaultProviderInstance();
    private static volatile String _remoteCodebase = null;

    public static void setCodebase(String remoteCodebase) {
        _remoteCodebase = remoteCodebase;
    }

    @Override
    public Class<?> loadClass(String codebase, String name, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return this._delegateLoaderSpi.loadClass(_remoteCodebase, name, defaultLoader);
    }

    @Override
    public Class<?> loadProxyClass(String codebase, String[] interfaces, ClassLoader defaultLoader) throws MalformedURLException, ClassNotFoundException {
        return this._delegateLoaderSpi.loadProxyClass(_remoteCodebase, interfaces, defaultLoader);
    }

    @Override
    public ClassLoader getClassLoader(String codebase) throws MalformedURLException {
        return this._delegateLoaderSpi.getClassLoader(_remoteCodebase);
    }

    @Override
    public String getClassAnnotation(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("class may not be null");
        }
        String annotation = null;
        if (clazz.getProtectionDomain().getCodeSource() != null) {
            try {
                File file = new File(clazz.getProtectionDomain().getCodeSource().getLocation().getPath());
                annotation = file.toURI().toURL().toString();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return annotation;
    }
}

