/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol.extensions;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;

public class CallbackMatlabProxy {
    private final ExecutorService _executor = Executors.newFixedThreadPool(1, new DaemonThreadFactory());
    private final MatlabProxy _proxy;

    public CallbackMatlabProxy(MatlabProxy proxy) {
        this._proxy = proxy;
    }

    public String toString() {
        return "[" + this.getClass().getName() + " proxy=" + this._proxy + "]";
    }

    public void isConnected(final MatlabDataCallback<Boolean> callback) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean connected = CallbackMatlabProxy.this._proxy.isConnected();
                callback.invocationSucceeded(connected);
            }
        });
    }

    public void disconnect(final MatlabDataCallback<Boolean> callback) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean succeeded = CallbackMatlabProxy.this._proxy.disconnect();
                callback.invocationSucceeded(succeeded);
            }
        });
    }

    public void exit(final MatlabCallback callback) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CallbackMatlabProxy.this._proxy.exit();
                    callback.invocationSucceeded();
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void eval(final MatlabCallback callback, final String command) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CallbackMatlabProxy.this._proxy.eval(command);
                    callback.invocationSucceeded();
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void returningEval(final MatlabDataCallback<Object[]> callback, final String command, final int nargout) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] data = CallbackMatlabProxy.this._proxy.returningEval(command, nargout);
                    callback.invocationSucceeded(data);
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void feval(final MatlabCallback callback, final String functionName, final Object ... args) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CallbackMatlabProxy.this._proxy.feval(functionName, args);
                    callback.invocationSucceeded();
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void returningFeval(final MatlabDataCallback<Object[]> callback, final String functionName, final int nargout, final Object ... args) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object[] data = CallbackMatlabProxy.this._proxy.returningFeval(functionName, nargout, args);
                    callback.invocationSucceeded(data);
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void setVariable(final MatlabCallback callback, final String variableName, final Object value) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    CallbackMatlabProxy.this._proxy.setVariable(variableName, value);
                    callback.invocationSucceeded();
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public void getVariable(final MatlabDataCallback<Object> callback, final String variableName) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object data = CallbackMatlabProxy.this._proxy.getVariable(variableName);
                    callback.invocationSucceeded(data);
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    public <U> void invokeAndWait(final MatlabProxy.MatlabThreadCallable<U> callable, final MatlabDataCallback<U> callback) {
        this._executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Object data = CallbackMatlabProxy.this._proxy.invokeAndWait(callable);
                    callback.invocationSucceeded(data);
                }
                catch (MatlabInvocationException e) {
                    callback.invocationFailed(e);
                }
            }
        });
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory _delegateFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this._delegateFactory.newThread(r);
            thread.setName("MatlabCallbackInteractor Thread");
            thread.setDaemon(true);
            return thread;
        }
    }

    public static interface MatlabCallback {
        public void invocationSucceeded();

        public void invocationFailed(MatlabInvocationException var1);
    }

    public static interface MatlabDataCallback<V> {
        public void invocationSucceeded(V var1);

        public void invocationFailed(MatlabInvocationException var1);
    }
}

