/*
 * Decompiled with CFR 0.152.
 */
package matlabcontrol;

import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Timer;
import java.util.TimerTask;
import matlabcontrol.LocalHostRMIHelper;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabSessionImpl;

class MatlabBroadcaster {
    private static Registry _registry = null;
    private static final MatlabSessionImpl _session = new MatlabSessionImpl();
    private static final int BROADCAST_CHECK_PERIOD = 1000;
    private static final Timer _broadcastTimer = new Timer("MLC Broadcast Maintainer");

    private MatlabBroadcaster() {
    }

    static MatlabSessionImpl getSession() {
        return _session;
    }

    static synchronized void broadcast(int broadcastPort) throws MatlabConnectionException {
        if (_registry == null) {
            MatlabBroadcaster.setupRegistry(broadcastPort);
            MatlabBroadcaster.bindSession();
            MatlabBroadcaster.maintainRegistryConnection(broadcastPort);
        }
    }

    private static void setupRegistry(int broadcastPort) throws MatlabConnectionException {
        try {
            _registry = LocalHostRMIHelper.createRegistry(broadcastPort);
        }
        catch (Exception e) {
            try {
                _registry = LocalHostRMIHelper.getRegistry(broadcastPort);
            }
            catch (Exception ex) {
                throw new MatlabConnectionException("Could not create or connect to the RMI registry", ex);
            }
        }
    }

    private static void bindSession() throws MatlabConnectionException {
        try {
            UnicastRemoteObject.unexportObject(_session, true);
        }
        catch (NoSuchObjectException e) {
            // empty catch block
        }
        try {
            _registry.bind(_session.getSessionID(), LocalHostRMIHelper.exportObject(_session));
        }
        catch (Exception e) {
            throw new MatlabConnectionException("Could not register this session of MATLAB", e);
        }
    }

    private static void maintainRegistryConnection(final int broadcastPort) {
        _broadcastTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    _registry.lookup(_session.getSessionID());
                }
                catch (NotBoundException e) {
                    try {
                        MatlabBroadcaster.bindSession();
                    }
                    catch (MatlabConnectionException ex) {}
                }
                catch (RemoteException e) {
                    try {
                        MatlabBroadcaster.setupRegistry(broadcastPort);
                        MatlabBroadcaster.bindSession();
                    }
                    catch (MatlabConnectionException matlabConnectionException) {
                        // empty catch block
                    }
                }
            }
        }, 1000L, 1000L);
    }
}

