% Same as built-in ismember function but works also for mixed-type
% cell arrays and struct arrays.
%
% The built-in ismember function doesn't work for mixed-type cell arrays
% (e.g. ismember(2, {'foo', 2, 'bar'}) and for struct arrays. This function
% does.
%
% Syntax and parameters are identical to built-in ismember function. See
% >> doc ismember
% The behavior for the Locb values equals the built-in ismember function
% of R2013a and higher: Locb contains the lowest index in B for each value
% in A that is a member of B.
%
% Examples
%   Mixed-type cell array
%   >> [Lia, Locb] = ismember('foo', {1, 'foo', 2})  % Lia = true, Locb = 2
%
%   Struct array
%   >> r(1).a=1;
%   >> r(2).a=2;
%   >> s.a = 2;
%   >> [Lia, Locb] = ismember(s, r)   % Lia = true, Locb = 2
