% Get MATLAB version number from release string
%
% Returns the MATLAB version number from the given MATLAB release string
% (e.g. version number '8.2' for release string '2013b'. If release string
% could not be matched to version number, function throws an error with
% identifier 'mes:ml:ver:numFromRelease:UnkownRelease'.
% 
% Syntax: verNum = numFromRelease(release)
%
% Inputs
%   release - char array string with the release string which can be
%             specified with leading 'r', 'R' or without (supported
%             range is 'R2009a' - 'R2022b')
% 
% Outputs
%   verNum - the MATLAB version number as string (e.g. '8.2')
%
% Examples
%   >> verNum = numFromRelease('2013b')    % verNum = '8.2'
%
%   With leading 'r'
%   >> verNum = numFromRelease('r2017a')   % verNum = '9.2'
%
%   With leading 'R'
%   >> verNum = numFromRelease('R2017a')   % verNum = '9.2'
