% Get deep fieldnames of a potentially nested struct
%
% The built-in fieldnames function returns the fieldnames of a struct on
% first level only. This function returns all leaf fieldnames of a
% potentially nested struct.
%
% Syntax: deepFieldNames = fieldnames_deep(struct)
%
% Inputs
%   s - potentially nested struct
% 
% Outputs
%   deepFieldNames - cell array of character vectors with deep fieldnames
%
% Examples
%   >> s.a = 1;
%   >> s.b.c = 2;
%   >> s.b.d = 3;
%   >> fieldnames_deep(s)   % ans = {'a', 'b.c', 'b.d'}
