% Concatenate a string cell's items, using a separator.
%
% Join all items of a cell array of strings into one single string,
% setting every two items apart by a separator string.
%
% Syntax: joinedStr = strjoin(strcell, separator)
%
% Inputs
%   strcell   - cell array of the strings to join
%               Defaults to {} if not given.
%   separator - char array string that goes between strcell's items
%               Defaults to the ' ' space character if not given.
% 
% Outputs
%   joinedStr - char array string containing the joined strings
%
% Examples
%   >> strjoin({'one', 'two', 'three'})   % ans = 'one two three'
%   >> strjoin({'foo'; 'bar'}, ' -- ')    % ans = 'foo -- bar'
%   >> strjoin({'foo'})                   % ans = 'foo'
%   >> strjoin({'', ''}, ',')             % ans = ','
%   >> strjoin()                          % ans = ''
