% Determine if char array string starts with another string
%
% As Matlab's startsWith function is only available since R2016b, this
% function is a rudimentary substitute for older Matlab versions.
% As the original, this function is case-sensitive and returns always true
% if the second input is the empty string.
% Currently, function is 'rudimentary' substitute of the original as it
% does not support:
% (1) the start parameter as cell array;
% (2) the 'IgnoreCase' option to explicitly determine case sensitivy.
%
% Syntax: TF = startsWith(str, start)
%
% Inputs
%   str   - char array string whose beginning is compared against the
%           second input, or cell array of char array strings
%   start - char array string that is compared against the beginning of the
%           first input
% 
% Outputs
%   TF - true if first input starts with second input, otherwise false
%
% Examples
%   >> startsWith('hello', 'foo')            % ans = false
%   >> startsWith('hello', 'he')             % ans = true
%   >> startsWith({'pete', 'paul'}, 'pa')    % ans = [false, true]
