/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import com.modelengineers.lismo3_0.api.LicenseInformation;
import com.modelengineers.lismo3_0.api.LicenseStatus;
import com.modelengineers.lismo3_0.internal.CheckoutOption;
import com.modelengineers.lismo3_0.internal.FLEXlmErrorCode;
import com.modelengineers.lismo3_0.internal.FLEXlmSession;
import com.modelengineers.lismo3_0.internal.FLEXlmSetupParameter;
import com.modelengineers.lismo3_0.internal.Feature;
import com.modelengineers.lismo3_0.internal.GroupDuplicatesOption;
import com.modelengineers.lismo3_0.internal.InternalLicenseChangeListener;
import com.modelengineers.lismo3_0.internal.LismoLogger;
import com.modelengineers.lismo3_0.internal.exceptions.FLEXlmException;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class License {
    private static final String CHECKIN_REQUESTED_WITH_DELAY = "Checkin requested with delay of {0} seconds.";
    private static final String CHECKING_IN_LICENSE = "Checking in license of [{0}] in version [{1}] for tool [{2}].";
    private static final String CHECKED_IN_LICENSE = "Checked in license of [{0}] in version [{1}] for tool [{2}].";
    private static final String REMOVED_QUEUED_LICENSE = "Removed license of [{0}] in version [{1}] for tool [{2}] from checkout queue.";
    private static final String CHECK_IN_LICENSE_ABORTED = "Check in license of [{0}] in version [{1}] for tool [{2}] aborted.";
    private static final String CHECKIN_RESTARTED_WITH_DELAY = "Checkin restarted with delay of {0} seconds.";
    private static final String CHECKIN_ALREADY_REQUESTED = "Checkin already requested and will be restarted with delay of {0} seconds.";
    private static final String CHECKIN_STARTED_WITH_DELAY = "Checkin started with delay of {0} seconds.";
    private final ScheduledExecutorService checkinTaskExecutor = Executors.newScheduledThreadPool(0);
    private final Logger LOG;
    private final InternalLicenseChangeListener listener;
    private ScheduledCheckinTask checkinTask;
    private final Feature feature;
    private final String toolIdentifier;
    private CheckoutOption option;
    private GroupDuplicatesOption dupGroup;
    private int lingerTime;
    private FLEXlmSession session;
    private boolean checkedOut = false;
    private boolean queued;

    public License(FLEXlmSession fLEXlmSession, Feature feature, String string, InternalLicenseChangeListener internalLicenseChangeListener) {
        this.session = fLEXlmSession;
        this.feature = feature;
        this.toolIdentifier = string;
        this.listener = internalLicenseChangeListener;
        this.LOG = LismoLogger.getLogger(License.class, string);
    }

    public void setQueueMode(CheckoutOption checkoutOption) {
        this.option = checkoutOption;
    }

    public void setDupGroup(GroupDuplicatesOption groupDuplicatesOption) {
        this.dupGroup = groupDuplicatesOption;
    }

    public void setLinger(int n) {
        this.lingerTime = n;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public boolean isLicenseFor(String string, String string2) {
        return this.feature.isCompatible(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LicenseInformation getInformation() throws FLEXlmException {
        FLEXlmSession fLEXlmSession = this.session;
        synchronized (fLEXlmSession) {
            if (!this.session.isAlive()) {
                return null;
            }
            return this.session.getLicenseInformation(this.feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean checkout(int n) throws FLEXlmException {
        FLEXlmSession fLEXlmSession = this.session;
        synchronized (fLEXlmSession) {
            if (!this.session.isAlive()) {
                return false;
            }
            this.session.setAttribute(FLEXlmSetupParameter.LM_A_LINGER, this.lingerTime);
            try {
                this.session.checkOut(this.feature, n, this.option.getParam(), this.dupGroup.getParam());
            }
            catch (FLEXlmException fLEXlmException) {
                if (fLEXlmException.getErrorNumber() == FLEXlmErrorCode.LM_FEATQUEUE.errNr) {
                    this.queued = true;
                }
                throw fLEXlmException;
            }
        }
        this.updateStatus();
        return this.checkedOut;
    }

    public synchronized void checkin() {
        if (this.cancelCheckin() || this.queued) {
            this.doCheckin();
        }
    }

    public synchronized void checkin(int n) {
        if (n <= 0) {
            this.checkin();
        } else if (this.checkedOut) {
            this.LOG.info(MessageFormat.format(CHECKIN_REQUESTED_WITH_DELAY, n));
            if (this.checkinTask == null) {
                this.checkinTask = this.scheduleCheckin(n);
                this.LOG.info(MessageFormat.format(CHECKIN_STARTED_WITH_DELAY, n));
            } else {
                this.checkinTask.cancel();
                this.LOG.info(MessageFormat.format(CHECKIN_ALREADY_REQUESTED, n));
                this.checkinTask = this.scheduleCheckin(n);
                this.LOG.info(MessageFormat.format(CHECKIN_RESTARTED_WITH_DELAY, n));
            }
        }
    }

    public synchronized boolean cancelCheckin() {
        if (this.checkinTask != null) {
            this.checkinTask.cancel();
        }
        return this.checkedOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doCheckin() {
        FLEXlmSession fLEXlmSession = this.session;
        synchronized (fLEXlmSession) {
            if (!this.session.isAlive()) {
                return;
            }
            if (!this.queued) {
                this.LOG.info(MessageFormat.format(CHECKING_IN_LICENSE, this.feature.getName(), this.feature.getVersion(), this.toolIdentifier));
            }
            this.session.checkIn(this.feature);
        }
        this.checkedOut = false;
        this.checkinTask = null;
        if (!this.queued) {
            this.listener.licenseCheckedIn(this);
            this.LOG.info(MessageFormat.format(CHECKED_IN_LICENSE, this.feature.getName(), this.feature.getVersion(), this.toolIdentifier));
        } else {
            this.listener.licenseRemovedFromQueue(this);
            this.LOG.info(MessageFormat.format(REMOVED_QUEUED_LICENSE, this.feature.getName(), this.feature.getVersion(), this.toolIdentifier));
        }
        this.queued = false;
    }

    private ScheduledCheckinTask scheduleCheckin(int n) {
        CheckinTask checkinTask = new CheckinTask();
        return new ScheduledCheckinTask(this.checkinTaskExecutor.schedule(checkinTask, (long)n, TimeUnit.SECONDS), checkinTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized LicenseStatus updateStatus() {
        FLEXlmSession fLEXlmSession = this.session;
        synchronized (fLEXlmSession) {
            if (this.session.isAlive()) {
                LicenseStatus licenseStatus = this.session.getStatus(this.feature);
                this.checkedOut = licenseStatus == LicenseStatus.CHECKED_OUT;
                this.queued &= !this.checkedOut;
                return licenseStatus;
            }
        }
        this.checkedOut = false;
        this.queued = false;
        return LicenseStatus.NOT_CHECKED_OUT;
    }

    private class ScheduledCheckinTask {
        private final ScheduledFuture<?> future;
        private final CheckinTask task;

        public ScheduledCheckinTask(ScheduledFuture<?> scheduledFuture, CheckinTask checkinTask) {
            this.future = scheduledFuture;
            this.task = checkinTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            License license = License.this;
            synchronized (license) {
                this.future.cancel(false);
                this.task.cancel();
                License.this.LOG.info(MessageFormat.format(License.CHECK_IN_LICENSE_ABORTED, License.this.feature.getName(), License.this.feature.getVersion(), License.this.toolIdentifier));
            }
        }
    }

    private class CheckinTask
    implements Runnable {
        private boolean canceled = false;

        private CheckinTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            License license = License.this;
            synchronized (license) {
                if (!this.canceled) {
                    License.this.doCheckin();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            License license = License.this;
            synchronized (license) {
                this.canceled = true;
            }
        }
    }
}

