/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;

public class StraightenLinesDialog
extends JFrame {
    public boolean straightenRecursive;
    public boolean straightenIncomingLines;
    public boolean straightenOutgoingLines;
    public boolean stopAtLinesToSubsystems;
    public boolean resizeStartBlock;
    public int portSpacingForStartBlock;
    private MatlabProxy matlabControlProxy;
    public JButton applyButton;
    private JPanel buttonPanel;
    private JPanel contentPanel;
    private JPanel directionPanel;
    private JCheckBox incomingLinesCheckBox;
    private JPanel incomingLinesPanel;
    private JPanel innerDirectionPanel;
    private JPanel innerRangePanel;
    private JPanel innerResizePanel;
    private JPanel outerEmptyBoarderPanel;
    private JCheckBox outgoingLinesCheckBox;
    private JPanel outgoingLinesPanel;
    private JPanel portSpacingPanel;
    private JSpinner portSpacingSpinner;
    private JPanel portSpacingSpinnerPanel;
    private JLabel portSpacingTextField;
    private JPanel portSpacingTextFieldPanel;
    private JPanel rangePanel;
    private JCheckBox recursiveCheckBox;
    private JPanel recursivePanel;
    public JButton redoButton;
    private JPanel resizeCheckBoxPanel;
    private JPanel resizePanel;
    private JCheckBox resizeStartBlockCheckBox;
    private JCheckBox stopAtLinesToSubsystemsCheckBox;
    private JPanel stopAtLinesToSubsystemsPanel;
    public JButton undoButton;

    public StraightenLinesDialog() throws MatlabConnectionException {
        this.initComponents();
        this.setFrameIcon();
        this.initMatlabProxy();
    }

    public void saveSelection() {
        this.straightenRecursive = this.recursiveCheckBox.isSelected();
        this.straightenIncomingLines = this.incomingLinesCheckBox.isSelected();
        this.straightenOutgoingLines = this.outgoingLinesCheckBox.isSelected();
        this.stopAtLinesToSubsystems = this.stopAtLinesToSubsystemsCheckBox.isSelected();
        this.resizeStartBlock = this.resizeStartBlockCheckBox.isSelected();
        if (this.resizeStartBlock) {
            try {
                this.portSpacingSpinner.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.portSpacingForStartBlock = (Integer)this.portSpacingSpinner.getValue();
        }
    }

    private void setFrameIcon() {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("toolIcon.png"));
        this.setIconImage(imageIcon.getImage());
    }

    private void initMatlabProxy() throws MatlabConnectionException {
        MatlabProxyFactory matlabProxyFactory = new MatlabProxyFactory();
        this.matlabControlProxy = matlabProxyFactory.getProxy();
    }

    private void initComponents() {
        this.outerEmptyBoarderPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.directionPanel = new JPanel();
        this.innerDirectionPanel = new JPanel();
        this.incomingLinesPanel = new JPanel();
        this.incomingLinesCheckBox = new JCheckBox();
        this.outgoingLinesPanel = new JPanel();
        this.outgoingLinesCheckBox = new JCheckBox();
        this.rangePanel = new JPanel();
        this.innerRangePanel = new JPanel();
        this.recursivePanel = new JPanel();
        this.recursiveCheckBox = new JCheckBox();
        this.stopAtLinesToSubsystemsPanel = new JPanel();
        this.stopAtLinesToSubsystemsCheckBox = new JCheckBox();
        this.resizePanel = new JPanel();
        this.innerResizePanel = new JPanel();
        this.resizeCheckBoxPanel = new JPanel();
        this.resizeStartBlockCheckBox = new JCheckBox();
        this.portSpacingPanel = new JPanel();
        this.portSpacingTextFieldPanel = new JPanel();
        this.portSpacingTextField = new JLabel();
        this.portSpacingSpinnerPanel = new JPanel();
        this.portSpacingSpinner = new JSpinner();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.undoButton = new JButton();
        this.redoButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Straighten Lines from Block");
        this.setResizable(false);
        this.outerEmptyBoarderPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.outerEmptyBoarderPanel.setLayout(new BorderLayout(0, 5));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 3));
        this.directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        this.directionPanel.setLayout(new BorderLayout());
        this.innerDirectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerDirectionPanel.setLayout(new BoxLayout(this.innerDirectionPanel, 2));
        this.incomingLinesPanel.setLayout(new BorderLayout());
        this.incomingLinesCheckBox.setSelected(true);
        this.incomingLinesCheckBox.setText("Incoming Lines");
        this.incomingLinesCheckBox.setFocusPainted(false);
        this.incomingLinesPanel.add((Component)this.incomingLinesCheckBox, "Center");
        this.innerDirectionPanel.add(this.incomingLinesPanel);
        this.outgoingLinesPanel.setLayout(new BorderLayout());
        this.outgoingLinesCheckBox.setSelected(true);
        this.outgoingLinesCheckBox.setText("Outgoing Lines");
        this.outgoingLinesCheckBox.setFocusPainted(false);
        this.outgoingLinesPanel.add((Component)this.outgoingLinesCheckBox, "Center");
        this.innerDirectionPanel.add(this.outgoingLinesPanel);
        this.directionPanel.add((Component)this.innerDirectionPanel, "Center");
        this.contentPanel.add(this.directionPanel);
        this.rangePanel.setBorder(BorderFactory.createTitledBorder("Range"));
        this.rangePanel.setLayout(new BorderLayout(5, 0));
        this.innerRangePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerRangePanel.setLayout(new BorderLayout());
        this.recursivePanel.setLayout(new BorderLayout());
        this.recursiveCheckBox.setText("Recursive");
        this.recursiveCheckBox.setToolTipText("");
        this.recursiveCheckBox.setFocusPainted(false);
        this.recursivePanel.add((Component)this.recursiveCheckBox, "Center");
        this.innerRangePanel.add((Component)this.recursivePanel, "First");
        this.stopAtLinesToSubsystemsPanel.setLayout(new BorderLayout());
        this.stopAtLinesToSubsystemsCheckBox.setText("Stop at Lines to Subsystems");
        this.stopAtLinesToSubsystemsCheckBox.setFocusPainted(false);
        this.stopAtLinesToSubsystemsPanel.add((Component)this.stopAtLinesToSubsystemsCheckBox, "Last");
        this.innerRangePanel.add((Component)this.stopAtLinesToSubsystemsPanel, "Center");
        this.rangePanel.add((Component)this.innerRangePanel, "Center");
        this.contentPanel.add(this.rangePanel);
        this.resizePanel.setBorder(BorderFactory.createTitledBorder("Resize Start Block"));
        this.resizePanel.setLayout(new BorderLayout());
        this.innerResizePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.innerResizePanel.setLayout(new BoxLayout(this.innerResizePanel, 2));
        this.resizeCheckBoxPanel.setLayout(new BorderLayout(0, 5));
        this.resizeStartBlockCheckBox.setText("Resize Start Block");
        this.resizeStartBlockCheckBox.setFocusPainted(false);
        this.resizeStartBlockCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StraightenLinesDialog.this.resizeStartBlockCheckBoxActionPerformed(evt);
            }
        });
        this.resizeCheckBoxPanel.add((Component)this.resizeStartBlockCheckBox, "Center");
        this.innerResizePanel.add(this.resizeCheckBoxPanel);
        this.portSpacingPanel.setLayout(new BoxLayout(this.portSpacingPanel, 2));
        this.portSpacingTextFieldPanel.setLayout(new BorderLayout());
        this.portSpacingTextField.setText("               Port Spacing:         ");
        this.portSpacingTextField.setEnabled(false);
        this.portSpacingTextFieldPanel.add((Component)this.portSpacingTextField, "Center");
        this.portSpacingPanel.add(this.portSpacingTextFieldPanel);
        this.portSpacingSpinnerPanel.setLayout(new BorderLayout());
        this.portSpacingSpinner.setModel(new SpinnerNumberModel((Number)15, Integer.valueOf(1), null, (Number)1));
        this.portSpacingSpinner.setEnabled(false);
        this.portSpacingSpinner.setPreferredSize(new Dimension(51, 20));
        this.portSpacingSpinner.setValue(20);
        this.portSpacingSpinnerPanel.add((Component)this.portSpacingSpinner, "Center");
        this.portSpacingPanel.add(this.portSpacingSpinnerPanel);
        this.innerResizePanel.add(this.portSpacingPanel);
        this.resizePanel.add((Component)this.innerResizePanel, "Center");
        this.contentPanel.add(this.resizePanel);
        this.outerEmptyBoarderPanel.add((Component)this.contentPanel, "First");
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        this.applyButton.setText("Apply");
        this.applyButton.setCursor(new Cursor(0));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StraightenLinesDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.applyButton);
        this.undoButton.setText("Undo");
        this.undoButton.setEnabled(false);
        this.buttonPanel.add(this.undoButton);
        this.redoButton.setText("Redo");
        this.redoButton.setEnabled(false);
        this.buttonPanel.add(this.redoButton);
        this.outerEmptyBoarderPanel.add((Component)this.buttonPanel, "Center");
        this.getContentPane().add((Component)this.outerEmptyBoarderPanel, "Center");
        this.pack();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        this.checkIfExactlyOneBlockIsSelected();
    }

    private void checkIfExactlyOneBlockIsSelected() {
        boolean oneBlockSelected = false;
        try {
            oneBlockSelected = this.oneBlockIsSelected();
        }
        catch (MatlabInvocationException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage());
        }
        if (!oneBlockSelected) {
            JOptionPane.showMessageDialog(this, "First select one block from which to run the straightening process.", "No valid block selected", 2);
        }
    }

    private boolean oneBlockIsSelected() throws MatlabInvocationException {
        Object[] retArray = this.matlabControlProxy.returningFeval("mes.more.dialogs.StraightenLines.oneBlockIsSelected", 1, new Object[0]);
        return ((boolean[])retArray[0])[0];
    }

    private void resizeStartBlockCheckBoxActionPerformed(ActionEvent evt) {
        if (this.resizeStartBlockCheckBox.isSelected()) {
            this.portSpacingSpinner.setEnabled(true);
            this.portSpacingTextField.setEnabled(true);
        } else {
            this.portSpacingSpinner.setEnabled(false);
            this.portSpacingTextField.setEnabled(false);
        }
    }
}

