/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.MoRe;

import com.modelengineers.MoRe.TreeFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import matlabcontrol.MatlabConnectionException;
import matlabcontrol.MatlabInvocationException;
import matlabcontrol.MatlabProxy;
import matlabcontrol.MatlabProxyFactory;

public class SelectItemWithPathFromTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel filterPanel;
    private JTextField filterField;
    private JTree jTree;
    private JScrollPane scrollPane;
    private FilterFieldListener filterFieldListener;
    private String matlabFunctionForDoubleClick;

    public static DefaultMutableTreeNode makeTreeNode(String fullPath, Object userData, boolean isValidSelection) {
        return new DefaultMutableTreeNode(new TreeItem(fullPath, userData, isValidSelection));
    }

    public static DefaultMutableTreeNode makeTreeNode(String fullPath, Object userData) {
        return SelectItemWithPathFromTreePanel.makeTreeNode(fullPath, userData, true);
    }

    public SelectItemWithPathFromTreePanel() {
        this.setLayout(new BorderLayout());
        this.addScrollPaneWithTree();
        this.addFilterPanel();
    }

    public void setRootNode(DefaultMutableTreeNode rootNode) {
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.jTree.setModel(treeModel);
        this.filterFieldListener.initFilterFromJTreeModel();
        this.updateTreeNodes();
    }

    public JTree getjTree() {
        return this.jTree;
    }

    public JTextField getFilterField() {
        return this.filterField;
    }

    public void setMatlabFunctionForDoubleClick(String matlabFunction) {
        this.matlabFunctionForDoubleClick = matlabFunction;
    }

    public String getFullPathOfSelectedItem() {
        return this.getSelectedItem().fullPath;
    }

    public Object getUserDataOfSelectedItem() {
        return this.getSelectedItem().userData;
    }

    public boolean nodeIsGrayedOut(DefaultMutableTreeNode node) {
        Component nodeComponent = this.jTree.getCellRenderer().getTreeCellRendererComponent(this.jTree, node, false, false, false, 0, false);
        Color foregroundColor = nodeComponent.getForeground();
        return foregroundColor == Color.GRAY;
    }

    public void selectNode(DefaultMutableTreeNode node) {
        this.jTree.setSelectionPath(new TreePath(node.getPath()));
    }

    private void addScrollPaneWithTree() {
        this.createScrollPaneWithTree();
        this.add((Component)this.scrollPane, "Center");
    }

    private void createScrollPaneWithTree() {
        this.createTree();
        this.scrollPane = new JScrollPane(this.jTree);
    }

    private void createTree() {
        this.createDefaultTree();
        this.setUpTree();
    }

    private void createDefaultTree() {
        DefaultMutableTreeNode rootNode = this.createRootNodeOfDefaultTree();
        this.jTree = new JTree(rootNode);
    }

    private DefaultMutableTreeNode createRootNodeOfDefaultTree() {
        DefaultMutableTreeNode rootNode = SelectItemWithPathFromTreePanel.makeTreeNode("rootNode", null);
        DefaultMutableTreeNode childNode1 = SelectItemWithPathFromTreePanel.makeTreeNode("rootNode/childNode1", null);
        rootNode.add(childNode1);
        DefaultMutableTreeNode childNode2 = SelectItemWithPathFromTreePanel.makeTreeNode("rootNode/childNode2", null);
        rootNode.add(childNode2);
        return rootNode;
    }

    private void setUpTree() {
        this.jTree.getSelectionModel().setSelectionMode(1);
        this.jTree.addMouseListener(new JTreeMouseListener());
        this.jTree.setVisibleRowCount(10);
        this.jTree.setRowHeight(0);
        this.setUpJTreeToGrayOutNodesThatAreNoValidSelection();
    }

    private void setUpJTreeToGrayOutNodesThatAreNoValidSelection() {
        this.jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Component component = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                TreeItem item = (TreeItem)node.getUserObject();
                if (!item.isValidSelection) {
                    this.setForeground(Color.GRAY);
                }
                return component;
            }
        });
    }

    private void updateTreeNodes() {
        this.renameNamesOfTreeNodesToRelativePath();
        this.updateSelectionStateOfTree();
    }

    private void renameNamesOfTreeNodesToRelativePath() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.jTree.getModel().getRoot();
        Enumeration<TreeNode> treeEnumeration = rootNode.depthFirstEnumeration();
        while (treeEnumeration.hasMoreElements()) {
            this.renameNameOfTreeNodeToRelativePath((DefaultMutableTreeNode)treeEnumeration.nextElement());
        }
        ((DefaultTreeModel)this.jTree.getModel()).reload();
    }

    private void renameNameOfTreeNodeToRelativePath(DefaultMutableTreeNode node) {
        String nameOfNode;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        String fullPathOfNode = ((TreeItem)node.getUserObject()).fullPath;
        if (parentNode == null) {
            nameOfNode = fullPathOfNode;
        } else {
            String fullPathOfParent = ((TreeItem)parentNode.getUserObject()).fullPath;
            nameOfNode = this.getRelativePathOfNode(fullPathOfNode, fullPathOfParent);
        }
        ((TreeItem)node.getUserObject()).name = nameOfNode;
    }

    private String getRelativePathOfNode(String fullPathOfNode, String fullPathOfParent) {
        String relativePath = fullPathOfParent.isEmpty() ? fullPathOfNode : fullPathOfNode.substring(fullPathOfParent.length() + 1);
        return relativePath;
    }

    private void updateSelectionStateOfTree() {
        DefaultMutableTreeNode childNode;
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.jTree.getModel().getRoot();
        if (rootNode.getChildCount() == 1 && (childNode = (DefaultMutableTreeNode)rootNode.getChildAt(0)).isLeaf()) {
            TreePath pathToChildNode = new TreePath(new Object[]{rootNode, childNode});
            this.jTree.setSelectionPath(pathToChildNode);
        }
    }

    private void addFilterPanel() {
        this.createFilterPanel();
        this.add((Component)this.filterPanel, "First");
    }

    private void createFilterPanel() {
        this.filterPanel = new JPanel();
        this.filterPanel.setLayout(new BorderLayout());
        this.filterPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.addFilterField();
    }

    private void addFilterField() {
        this.createFilterField();
        this.filterPanel.add(this.filterField);
    }

    private void createFilterField() {
        this.filterField = new JTextField();
        this.filterField.setColumns(10);
        this.filterFieldListener = new FilterFieldListener();
        this.filterFieldListener.initFilterFromJTreeModel();
        this.filterField.getDocument().addDocumentListener(this.filterFieldListener);
    }

    private TreeItem getSelectedItem() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.jTree.getLastSelectedPathComponent();
        return (TreeItem)selectedNode.getUserObject();
    }

    class FilterFieldListener
    implements DocumentListener {
        private TreeFilter treeFilter;

        public void initFilterFromJTreeModel() {
            DefaultTreeModel unfilteredTreeModel = (DefaultTreeModel)SelectItemWithPathFromTreePanel.this.jTree.getModel();
            this.treeFilter = new TreeFilter((DefaultMutableTreeNode)unfilteredTreeModel.getRoot());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.contentChanged(e);
        }

        private void contentChanged(DocumentEvent e) {
            this.filterTreeNodes();
            SelectItemWithPathFromTreePanel.this.updateTreeNodes();
        }

        private void filterTreeNodes() {
            DefaultMutableTreeNode filteredTree = this.treeFilter.filter(new StringIsSubstringFilterCondition(SelectItemWithPathFromTreePanel.this.filterField.getText()));
            DefaultTreeModel filteredTreeModel = new DefaultTreeModel(filteredTree);
            SelectItemWithPathFromTreePanel.this.jTree.setModel(filteredTreeModel);
        }
    }

    class JTreeMouseListener
    extends MouseAdapter {
        JTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int selectedRow;
            if (e.getClickCount() == 2 && SelectItemWithPathFromTreePanel.this.matlabFunctionForDoubleClick != null && (selectedRow = SelectItemWithPathFromTreePanel.this.jTree.getRowForLocation(e.getX(), e.getY())) > 0) {
                TreePath selectedPath = SelectItemWithPathFromTreePanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                TreeItem selectedItem = (TreeItem)((DefaultMutableTreeNode)selectedPath.getLastPathComponent()).getUserObject();
                MatlabProxyFactory matlabProxyFactory = new MatlabProxyFactory();
                try {
                    MatlabProxy matlabControlProxy = matlabProxyFactory.getProxy();
                    String matlabCommand = SelectItemWithPathFromTreePanel.this.matlabFunctionForDoubleClick + "('" + selectedItem.fullPath + "');";
                    matlabControlProxy.eval(matlabCommand);
                    matlabControlProxy.disconnect();
                }
                catch (MatlabConnectionException error) {
                    error.printStackTrace();
                }
                catch (MatlabInvocationException error) {
                    error.printStackTrace();
                }
            }
        }
    }

    static class StringIsSubstringFilterCondition
    implements TreeFilter.FilterCondition {
        private final String filter;

        public StringIsSubstringFilterCondition(String filter) {
            this.filter = filter;
        }

        @Override
        public boolean keepNode(DefaultMutableTreeNode node) {
            TreeItem item = (TreeItem)node.getUserObject();
            return item.fullPath.toUpperCase().contains(this.filter.toUpperCase());
        }
    }

    static class TreeItem {
        private String name;
        public final String fullPath;
        public final Object userData;
        public final boolean isValidSelection;

        public TreeItem(String fullPath, Object userData, boolean isValidSelection) {
            this.fullPath = fullPath;
            this.userData = userData;
            this.isValidSelection = isValidSelection;
        }

        public String toString() {
            return this.name;
        }
    }
}

