/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.internal;

import java.util.Objects;

public class Feature {
    private final String name;
    private final String version;
    private double versionNumber;

    public Feature(String string, String string2) {
        this.name = string.trim();
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("No feature name provided.");
        }
        this.version = string2.trim();
        this.versionNumber = this.parseVersion(this.version);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isCompatible(String string, String string2) {
        return Objects.equals(string, this.name) && (string2 == null || this.versionNumber >= this.parseVersion(string2));
    }

    private double parseVersion(String string) {
        if (string.trim().length() > 10) {
            throw new IllegalArgumentException("Illegal version format. Not more than 10 characters are allowed.");
        }
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal version format. Format must be like 1.0, 2.5, ...", numberFormatException);
        }
    }
}

