/*
 * Decompiled with CFR 0.152.
 */
package com.modelengineers.lismo3_0.api;

import com.modelengineers.lismo3_0.api.exceptions.ConfigurationFileDoesNotExistException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public class LismoConfig {
    public static final String LICENSE_SERVER_ID_KEY = "license_server_id";
    public static final String LICENSE_FILE_DIR_KEY = "license_file_dir";
    public static final String CONFIG_FILE_DEFAULT = "./lismo.config";
    private File configFile = new File("./lismo.config");
    public static final String LICENSE_SERVER_ID_DEFVAL = "";
    public static final String LICENSE_FILE_DIR_DEFVAL = "";
    private Properties configuration;

    public LismoConfig() {
        this(null);
    }

    public LismoConfig(String string) {
        if (string != null && !string.trim().isEmpty()) {
            this.configFile = new File(string);
        }
        this.configuration = new Properties();
    }

    public void loadConfigFile(boolean bl) throws ConfigurationFileDoesNotExistException, IOException {
        File file;
        String string;
        if (!this.configFile.exists()) {
            if (bl) {
                this.addConfiguration(LICENSE_SERVER_ID_KEY, "");
                this.addConfiguration(LICENSE_FILE_DIR_KEY, "");
                this.saveConfigFile();
            } else {
                throw new ConfigurationFileDoesNotExistException("The configuration file " + this.configFile + " does not exist.");
            }
        }
        try (Object object = new InputStreamReader((InputStream)new FileInputStream(this.configFile), StandardCharsets.UTF_8);){
            this.configuration.load((Reader)object);
        }
        object = this.getConfiguration(LICENSE_FILE_DIR_KEY, false);
        if (object != null && !((String)object).equals(string = (file = new File((String)object)).getPath())) {
            this.addConfiguration(LICENSE_FILE_DIR_KEY, string);
        }
    }

    public void addConfiguration(String string, String string2) {
        this.configuration.put(string, string2);
    }

    public void saveConfigFile() throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.configFile), StandardCharsets.UTF_8);){
            this.configuration.store(outputStreamWriter, LismoConfig.getLicenseFileHelpText());
        }
    }

    public static String getLicenseFileHelpText() {
        return "#################################################################################################\n Lismo Configuration File\n Usage examples:\n  The Server with IP '192.168.1.100' is to be used as a floating license server on port 27000:\n     license_server_id=27000@192.168.1.100\n  The licenses reside in file './license.lic':\n     license_file_dir=./license.lic\n  Both 'localhost' and '192.168.1.100' are to be used as a floating license server on port 27000:\n     license_server_id=27000@localhost" + File.pathSeparator + "27000@192.168.1.100\n  The licenses reside in directory './licenses' and in file './license.lic':\n     license_file_dir=./licenses" + File.pathSeparator + "./license.lic\n\n  In case of a three server redundancy setup, use ',' as separator between each server entry.\n##################################################################################################\n";
    }

    public String getConfiguration(String string, boolean bl) {
        if (bl && this.configuration.getProperty(string) == null) {
            if (string.equals(LICENSE_FILE_DIR_KEY)) {
                return "";
            }
            if (string.equals(LICENSE_SERVER_ID_KEY)) {
                return "";
            }
        }
        return this.configuration.getProperty(string);
    }

    public String getLicenseLocation() {
        return this.getConfiguration(LICENSE_FILE_DIR_KEY, true);
    }

    public String getLicenseServers() {
        return this.getConfiguration(LICENSE_SERVER_ID_KEY, true);
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl = false;
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("--config") || i + 1 >= stringArray.length) continue;
            bl = true;
            string = stringArray[i + 1];
            break;
        }
        if (bl) {
            LismoConfig lismoConfig = new LismoConfig(string);
            lismoConfig.loadConfigFile(true);
        }
    }
}

